/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.audio.AudioOutInterface;
import com.grapeshot.halfnes.mappers.Mapper;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SwingAudioImpl
implements AudioOutInterface {
    private boolean soundEnable = PrefsSingleton.get().getBoolean("soundEnable", true);
    private SourceDataLine sdl;
    private volatile byte[] audiobuf;
    private volatile int bufptr = 0;
    protected float outputvol = (float)((double)PrefsSingleton.get().getInt("outputvol", 13107) / 16384.0);
    protected int samplesPerFrame;
    static final int CHANNELS = 1;
    static final int SAMPLE_SIZE = 16;
    static final int BYTES_PER_SAMPLE = 2;

    public SwingAudioImpl(NES nes, int samplerate, Mapper.TVType tvtype) {
        double fps;
        switch (tvtype) {
            default: {
                fps = 60.0;
                break;
            }
            case PAL: 
            case DENDY: {
                fps = 50.0;
            }
        }
        if (this.soundEnable) {
            this.samplesPerFrame = (int)Math.ceil((double)(samplerate * 1) / fps);
            this.audiobuf = new byte[this.samplesPerFrame * 2];
            try {
                AudioFormat af = new AudioFormat(samplerate, 16, 1, true, false);
                this.sdl = AudioSystem.getSourceDataLine(af);
                this.sdl.open(af, this.samplesPerFrame * 2 * 1 * 2);
                this.sdl.start();
            }
            catch (LineUnavailableException a) {
                System.err.println(a);
                nes.messageBox("Unable to inintialize sound.");
                this.soundEnable = false;
            }
            catch (IllegalArgumentException a) {
                System.err.println(a);
                nes.messageBox("Unable to inintialize sound.");
                this.soundEnable = false;
            }
        }
    }

    @Override
    public void flushFrame(boolean waitIfBufferFull) {
        if (this.soundEnable) {
            if (this.sdl.available() < this.bufptr) {
                if (waitIfBufferFull) {
                    this.sdl.write(this.audiobuf, 0, this.bufptr);
                }
            } else {
                this.sdl.write(this.audiobuf, 0, this.bufptr);
            }
        }
        this.bufptr = 0;
    }

    @Override
    public void outputSample(int sample) {
        if (this.soundEnable) {
            if ((sample = (int)((float)sample * this.outputvol)) < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            if (sample > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            }
            this.audiobuf[this.bufptr] = (byte)(sample & 0xFF);
            this.audiobuf[this.bufptr + 1] = (byte)(sample >> 8 & 0xFF);
            this.bufptr += 2;
        }
    }

    @Override
    public void pause() {
        if (this.soundEnable) {
            this.sdl.flush();
            this.sdl.stop();
        }
    }

    @Override
    public void resume() {
        if (this.soundEnable) {
            this.sdl.start();
        }
    }

    @Override
    public final void destroy() {
        if (this.soundEnable) {
            this.sdl.stop();
            this.sdl.close();
        }
    }

    @Override
    public final boolean bufferHasLessThan(int samples) {
        return this.sdl == null ? false : this.sdl.getBufferSize() - this.sdl.available() <= samples;
    }
}

