/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.cheats;

import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.cheats.Patch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ActionReplay {
    private static final int RAM_SIZE = 2047;
    private final CPURAM cpuram;
    private final HashMap<Integer, Patch> patches = new HashMap();
    private final List<Integer> foundAddresses = new ArrayList<Integer>();

    public ActionReplay(CPURAM cpuram) {
        this.cpuram = cpuram;
    }

    public HashMap<Integer, Patch> getPatches() {
        return this.patches;
    }

    public void addMemoryPatch(Patch patch) {
        if (!this.patches.containsKey(patch.getAddress())) {
            this.patches.put(patch.getAddress(), patch);
        }
    }

    public void applyPatches() {
        this.cpuram.setPatches(this.patches);
    }

    public void clear() {
        this.patches.clear();
    }

    public List<Integer> newSearchInMemory(byte value) {
        this.foundAddresses.clear();
        for (int address = 0; address < 2047; ++address) {
            if ((this.cpuram.read(address) & 0xFF) != (value & 0xFF)) continue;
            this.foundAddresses.add(address);
        }
        return this.foundAddresses;
    }

    public List<Integer> getFoundAddresses() {
        return this.foundAddresses;
    }

    public List<Integer> continueSearch(byte value) {
        ArrayList<Integer> addressesToRemove = new ArrayList<Integer>();
        for (int address : this.foundAddresses) {
            if ((this.cpuram.read(address) & 0xFF) == (value & 0xFF)) continue;
            addressesToRemove.add(address);
        }
        this.foundAddresses.removeAll(addressesToRemove);
        return this.foundAddresses;
    }
}

