/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class MMC2Mapper
extends Mapper {
    boolean chrlatchL = true;
    boolean chrlatchR = false;
    int chrbankL1 = 0;
    int chrbankR1 = 0;
    int chrbankL2 = 0;
    int chrbankR2 = 0;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr >= 40960 && addr <= 45055) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + 8 * (data & 0xF)) & this.chrsize - 1;
            }
        } else if (addr >= 45056 && addr <= 49151) {
            this.chrbankL1 = data & 0x1F;
            this.setupPPUBanks();
        } else if (addr >= 49152 && addr <= 53247) {
            this.chrbankL2 = data & 0x1F;
            this.setupPPUBanks();
        } else if (addr >= 53248 && addr <= 57343) {
            this.chrbankR1 = data & 0x1F;
            this.setupPPUBanks();
        } else if (addr >= 57344 && addr <= 61439) {
            this.chrbankR2 = data & 0x1F;
            this.setupPPUBanks();
        } else if (addr >= 61440 && addr <= 65535) {
            this.setmirroring((data & 1) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        }
    }

    @Override
    public int ppuRead(int addr) {
        int retval = super.ppuRead(addr);
        if ((addr & 8) != 0) {
            switch (addr >> 4) {
                case 253: {
                    if ((addr & 3) != 0) break;
                    this.chrlatchL = false;
                    this.setupPPUBanks();
                    break;
                }
                case 254: {
                    if ((addr & 3) == 0) {
                        this.chrlatchL = true;
                        this.setupPPUBanks();
                        break;
                    }
                }
                case 509: {
                    this.chrlatchR = false;
                    this.setupPPUBanks();
                    break;
                }
                case 510: {
                    this.chrlatchR = true;
                    this.setupPPUBanks();
                }
            }
        }
        return retval;
    }

    private void setupPPUBanks() {
        if (this.chrlatchL) {
            this.setppubank(4, 0, this.chrbankL2);
        } else {
            this.setppubank(4, 0, this.chrbankL1);
        }
        if (this.chrlatchR) {
            this.setppubank(4, 4, this.chrbankR2);
        } else {
            this.setppubank(4, 4, this.chrbankR1);
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banksize * banknum + i) % this.chrsize;
        }
    }
}

