/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.MMC3Mapper;

public class Mapper119
extends MMC3Mapper {
    int[] chrRam = new int[8192];

    @Override
    public int ppuRead(int addr) {
        if (addr < 8192) {
            this.checkA12(addr);
            return this.chr_map[addr >> 10] > 65535 ? this.chrRam[this.chr_map[addr >> 10] + (addr & 0x3FF) & 0x1FFF] : this.chr[(this.chr_map[addr >> 10] & 0xFFFF) + (addr & 0x3FF)];
        }
        return super.ppuRead(addr);
    }

    @Override
    public void ppuWrite(int addr, int data) {
        if (addr < 8192) {
            this.checkA12(addr);
            if (this.chr_map[addr >> 10] > 63) {
                this.chrRam[this.chr_map[addr >> 10] + (addr & 0x3FF) & 0x1FFF] = data;
            }
        } else {
            super.ppuWrite(addr, data);
        }
    }

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * i;
            this.prg_map[i + 8] = 1024 * i;
        }
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
        this.setbank6();
    }

    @Override
    protected void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i);
        }
    }
}

