/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper185
extends Mapper {
    boolean chr_enabled = true;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public int ppuRead(int addr) {
        if (!this.chr_enabled) {
            this.chr_enabled = true;
            return 18;
        }
        if (addr < 8192) {
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        return super.ppuRead(addr);
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        for (int i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * (data & 3)) & this.chrsize - 1;
            this.chr_enabled = (this.chr_map[i] & 0xF) > 0 && this.chr_map[i] != 19;
        }
    }
}

