/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class VRC2Mapper
extends Mapper {
    int prgbank0;
    int prgbank1 = 0;
    int[] chrbank = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        boolean bit0 = (addr & 2) != 0;
        boolean bit1 = (addr & 1) != 0;
        switch (addr >> 12) {
            case 8: {
                this.prgbank0 = data & 0xF;
                break;
            }
            case 9: {
                switch (data & 1) {
                    case 0: {
                        this.setmirroring(Mapper.MirrorType.V_MIRROR);
                        break;
                    }
                    case 1: {
                        this.setmirroring(Mapper.MirrorType.H_MIRROR);
                    }
                }
                break;
            }
            case 10: {
                this.prgbank1 = data & 0xF;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                data &= 0xF;
                int whichreg = (addr - 45056 >> 11) + (bit1 ? 1 : 0);
                int oldval = this.chrbank[whichreg];
                if (!bit0) {
                    oldval &= 0xF0;
                    oldval |= data;
                } else {
                    oldval &= 0xF;
                    oldval |= data << 4;
                }
                this.chrbank[whichreg] = oldval;
            }
        }
        if (addr < 61440) {
            this.setbanks();
        }
    }

    private void setbanks() {
        int i;
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.setppubank(1, i, this.chrbank[i] >> 1);
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }
}

