/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class VRC4Mapper
extends Mapper {
    int[][][] registerselectbits = new int[][][]{new int[][]{{1, 2}, {6, 7}}, new int[][]{{2, 3}, {0, 1}}, new int[][]{{3, 2}, {1, 0}}};
    int[][] registers;
    int prgbank0;
    int prgbank1 = 0;
    int[] chrbank = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    boolean prgmode;
    boolean irqmode;
    boolean irqenable;
    boolean irqack;
    boolean firedinterrupt = false;
    int irqreload;
    int irqcounter = 22;
    boolean vrc2mirror;
    int prescaler = 341;

    public VRC4Mapper(int mappernum) {
        switch (mappernum) {
            case 21: {
                this.registers = this.registerselectbits[0];
                break;
            }
            case 23: {
                this.registers = this.registerselectbits[1];
                break;
            }
            case 25: {
                this.registers = this.registerselectbits[2];
                break;
            }
            default: {
                this.registers = this.registerselectbits[0];
            }
        }
    }

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
        System.err.println(utils.hex(this.crc));
        this.vrc2mirror = this.crc == 3079733068L || this.crc == 764755005L || this.crc == 1686212549L || this.crc == 504541066L || this.crc == 880867291L;
        System.err.println(this.vrc2mirror);
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        boolean bit0 = (addr & 1 << this.registers[0][0]) != 0 || (addr & 1 << this.registers[1][0]) != 0;
        boolean bit1 = (addr & 1 << this.registers[0][1]) != 0 || (addr & 1 << this.registers[1][1]) != 0;
        switch (addr >> 12) {
            case 8: {
                this.prgbank0 = data & 0x1F;
                break;
            }
            case 9: {
                if (!bit1) {
                    if (this.vrc2mirror) {
                        switch (data & 1) {
                            case 0: {
                                this.setmirroring(Mapper.MirrorType.V_MIRROR);
                                break;
                            }
                            case 1: {
                                this.setmirroring(Mapper.MirrorType.H_MIRROR);
                            }
                        }
                        break;
                    }
                    switch (data & 3) {
                        case 0: {
                            this.setmirroring(Mapper.MirrorType.V_MIRROR);
                            break;
                        }
                        case 1: {
                            this.setmirroring(Mapper.MirrorType.H_MIRROR);
                            break;
                        }
                        case 2: {
                            this.setmirroring(Mapper.MirrorType.SS_MIRROR0);
                            break;
                        }
                        case 3: {
                            this.setmirroring(Mapper.MirrorType.SS_MIRROR1);
                        }
                    }
                    break;
                }
                this.prgmode = (data & 2) != 0;
                break;
            }
            case 10: {
                this.prgbank1 = data & 0x1F;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                data &= 0xF;
                int whichreg = (addr - 45056 >> 11) + (bit1 ? 1 : 0);
                int oldval = this.chrbank[whichreg];
                if (!bit0) {
                    oldval &= 0xF0;
                    oldval |= data;
                } else {
                    oldval &= 0xF;
                    oldval |= data << 4;
                }
                this.chrbank[whichreg] = oldval;
                break;
            }
            case 15: {
                if (!bit1) {
                    if (!bit0) {
                        this.irqreload &= 0xF0;
                        this.irqreload |= data & 0xF;
                        break;
                    }
                    this.irqreload &= 0xF;
                    this.irqreload |= (data & 0xF) << 4;
                    break;
                }
                if (!bit0) {
                    this.irqack = (data & 1) != 0;
                    this.irqenable = (data & 2) != 0;
                    boolean bl = this.irqmode = (data & 4) != 0;
                    if (this.irqenable) {
                        this.irqcounter = this.irqreload;
                        this.prescaler = 341;
                    }
                    if (this.firedinterrupt) {
                        --this.cpu.interrupt;
                    }
                    this.firedinterrupt = false;
                    break;
                }
                this.irqenable = this.irqack;
                if (this.firedinterrupt) {
                    --this.cpu.interrupt;
                }
                this.firedinterrupt = false;
            }
        }
        if (addr < 61440) {
            this.setbanks();
        }
    }

    private void setbanks() {
        int i;
        if (!this.prgmode) {
            for (i = 1; i <= 16; ++i) {
                this.prg_map[32 - i] = this.prgsize - 1024 * i;
            }
            for (i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) % this.prgsize;
            }
            for (i = 0; i < 8; ++i) {
                this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) % this.prgsize;
            }
        } else {
            for (i = 1; i <= 8; ++i) {
                this.prg_map[8 - i] = this.prgsize - 1024 * i;
            }
            for (i = 1; i <= 8; ++i) {
                this.prg_map[32 - i] = this.prgsize - 1024 * i;
            }
            for (i = 0; i < 8; ++i) {
                this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank0) % this.prgsize;
            }
            for (i = 0; i < 8; ++i) {
                this.prg_map[i + 16] = 1024 * (i + 8 * this.prgbank1) % this.prgsize;
            }
        }
        for (i = 0; i < 8; ++i) {
            this.setppubank(1, i, this.chrbank[i]);
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqenable) {
            if (this.irqmode) {
                this.scanlinecount();
            } else {
                this.prescaler -= 3;
                if (this.prescaler <= 0) {
                    this.prescaler += 341;
                    this.scanlinecount();
                }
            }
        }
    }

    public void scanlinecount() {
        if (this.irqenable) {
            if (this.irqcounter == 255) {
                this.irqcounter = this.irqreload;
                if (!this.firedinterrupt) {
                    ++this.cpu.interrupt;
                }
                this.firedinterrupt = true;
            } else {
                ++this.irqcounter;
            }
        }
    }
}

