/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import net.java.games.input.Controller;
import net.java.games.input.DummyWindow;
import net.java.games.input.WinTabDevice;
import net.java.games.input.WinTabPacket;

public class WinTabContext {
    private DummyWindow window;
    private long hCTX;
    private Controller[] controllers;

    public WinTabContext(DummyWindow window) {
        this.window = window;
    }

    public Controller[] getControllers() {
        if (this.hCTX == 0L) {
            throw new IllegalStateException("Context must be open before getting the controllers");
        }
        return this.controllers;
    }

    public synchronized void open() {
        this.hCTX = WinTabContext.nOpen(this.window.getHwnd());
        ArrayList<WinTabDevice> devices = new ArrayList<WinTabDevice>();
        int numSupportedDevices = WinTabContext.nGetNumberOfSupportedDevices();
        for (int i = 0; i < numSupportedDevices; ++i) {
            devices.add(WinTabDevice.createDevice(this, i));
        }
        this.controllers = devices.toArray(new Controller[0]);
    }

    public synchronized void close() {
        WinTabContext.nClose(this.hCTX);
    }

    public synchronized void processEvents() {
        WinTabPacket[] packets = WinTabContext.nGetPackets(this.hCTX);
        for (int i = 0; i < packets.length; ++i) {
            ((WinTabDevice)this.getControllers()[0]).processPacket(packets[i]);
        }
    }

    private static native int nGetNumberOfSupportedDevices();

    private static native long nOpen(long var0);

    private static native void nClose(long var0);

    private static native WinTabPacket[] nGetPackets(long var0);
}

