/*
 * Decompiled with CFR 0.152.
 */
package z80core;

import z80core.IMemIoOps;

public class MemIoOps
implements IMemIoOps {
    private byte[] z80Ram = null;
    private byte[] z80Ports = null;
    protected long tstates = 0L;

    public MemIoOps() {
        this.z80Ram = new byte[65536];
        this.z80Ports = new byte[65536];
    }

    public MemIoOps(int ramSize, int portSize) {
        if (ramSize < 0 || ramSize > 65536) {
            throw new IndexOutOfBoundsException("ramSize Out of Range [0x0000 - 0x10000");
        }
        if (ramSize > 0) {
            this.z80Ram = new byte[ramSize];
        }
        if (portSize < 0 || portSize > 65536) {
            throw new IndexOutOfBoundsException("portSize Out of Range [0x0000 - 0x10000");
        }
        if (portSize > 0) {
            this.z80Ports = new byte[portSize];
        }
    }

    public void setRam(byte[] ram) {
        this.z80Ram = ram;
    }

    public void setPorts(byte[] ports) {
        this.z80Ram = ports;
    }

    @Override
    public int fetchOpcode(int address) {
        this.tstates += 4L;
        return this.z80Ram[address] & 0xFF;
    }

    @Override
    public int peek8(int address) {
        this.tstates += 3L;
        return this.z80Ram[address] & 0xFF;
    }

    @Override
    public void poke8(int address, int value) {
        this.tstates += 3L;
        this.z80Ram[address] = (byte)value;
    }

    @Override
    public int peek16(int address) {
        int lsb = this.peek8(address);
        int msb = this.peek8(address + 1);
        return msb << 8 | lsb;
    }

    @Override
    public void poke16(int address, int word) {
        this.poke8(address, word);
        this.poke8(address + 1, word >>> 8);
    }

    @Override
    public int inPort(int port) {
        this.tstates += 4L;
        return this.z80Ports[port] & 0xFF;
    }

    @Override
    public void outPort(int port, int value) {
        this.tstates += 4L;
        this.z80Ports[port] = (byte)value;
    }

    @Override
    public void addressOnBus(int address, int tstates) {
        this.tstates += (long)tstates;
    }

    @Override
    public void interruptHandlingTime(int tstates) {
        this.tstates += (long)tstates;
    }

    @Override
    public boolean isActiveINT() {
        return false;
    }

    @Override
    public boolean setActiveINT(boolean val) {
        return false;
    }

    @Override
    public long getTstates() {
        return this.tstates;
    }

    @Override
    public void reset() {
        this.tstates = 0L;
    }
}

