/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.javasound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.AudioServerProvider;
import org.jaudiolibs.audioservers.ext.Device;
import org.jaudiolibs.audioservers.javasound.JSAudioServer;
import org.jaudiolibs.audioservers.javasound.JSDevice;
import org.jaudiolibs.audioservers.javasound.JSTimingMode;

public class JSAudioServerProvider
extends AudioServerProvider {
    private static final Logger LOG = Logger.getLogger(JSAudioServerProvider.class.getName());

    public <T> T find(Class<T> type) {
        Iterator<T> itr = this.findAll(type).iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        return null;
    }

    public <T> Iterable<T> findAll(Class<T> type) {
        if (type.isAssignableFrom(Device.class)) {
            return JSAudioServerProvider.findDevices();
        }
        return Collections.emptyList();
    }

    public String getLibraryName() {
        return "JavaSound";
    }

    public AudioServer createServer(AudioConfiguration config, AudioClient client) throws Exception {
        Device inputDevice = JSAudioServerProvider.findInputDevice(config);
        Mixer inputMixer = inputDevice == null ? null : (Mixer)inputDevice.find(Mixer.class);
        Device outputDevice = JSAudioServerProvider.findOutputDevice(config);
        Mixer outputMixer = outputDevice == null ? null : (Mixer)outputDevice.find(Mixer.class);
        JSTimingMode timingMode = JSAudioServerProvider.findTimingMode(config);
        ArrayList<Object> exts = new ArrayList<Object>();
        if (inputDevice != null) {
            exts.add(inputDevice);
        }
        if (outputDevice != null && outputDevice != inputDevice) {
            exts.add(outputDevice);
        }
        exts.add((Object)timingMode);
        config = new AudioConfiguration(config.getSampleRate(), config.getInputChannelCount(), config.getOutputChannelCount(), config.getMaxBufferSize(), exts.toArray());
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Building JSAudioServer\n");
            sb.append(config);
            sb.append("Input Mixer : ").append(inputMixer).append('\n');
            sb.append("Output Mixer : ").append(outputMixer).append('\n');
            LOG.fine(sb.toString());
        }
        return new JSAudioServer(inputMixer, outputMixer, timingMode, config, client);
    }

    private static Device findInputDevice(AudioConfiguration config) {
        for (Device dev : config.findAll(Device.class)) {
            Mixer m;
            if (dev.getMaxInputChannels() <= 0 || (m = (Mixer)dev.find(Mixer.class)) == null) continue;
            return dev;
        }
        return null;
    }

    private static Device findOutputDevice(AudioConfiguration config) {
        for (Device dev : config.findAll(Device.class)) {
            Mixer m;
            if (dev.getMaxOutputChannels() <= 0 || (m = (Mixer)dev.find(Mixer.class)) == null) continue;
            return dev;
        }
        return null;
    }

    private static JSTimingMode findTimingMode(AudioConfiguration config) {
        JSTimingMode mode = (JSTimingMode)((Object)config.find(JSTimingMode.class));
        if (mode == null) {
            return JSTimingMode.Blocking;
        }
        return mode;
    }

    private static List<Device> findDevices() {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (mixerInfos.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Device> devices = new ArrayList<Device>(mixerInfos.length);
        for (Mixer.Info info : mixerInfos) {
            Mixer mixer = AudioSystem.getMixer(info);
            int ins = JSAudioServerProvider.getMaximumChannels(mixer, true);
            int outs = JSAudioServerProvider.getMaximumChannels(mixer, false);
            devices.add(new JSDevice(mixer, ins, outs));
        }
        return devices;
    }

    private static int getMaximumChannels(Mixer mixer, boolean input) {
        Line.Info[] lines;
        int max = 0;
        for (Line.Info line : lines = input ? mixer.getTargetLineInfo() : mixer.getSourceLineInfo()) {
            AudioFormat[] formats;
            if (!(line instanceof DataLine.Info)) continue;
            for (AudioFormat format : formats = ((DataLine.Info)line).getFormats()) {
                int channels = format.getChannels();
                if (channels == -1) {
                    max = 32;
                    continue;
                }
                if (channels <= max) continue;
                max = channels;
            }
        }
        return max;
    }
}

