/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.AddressSpace;

public class InterruptManager
implements AddressSpace {
    private final boolean gbc;
    private boolean ime;
    private int interruptFlag = 225;
    private int interruptEnabled;
    private int pendingEnableInterrupts = -1;
    private int pendingDisableInterrupts = -1;

    public InterruptManager(boolean gbc) {
        this.gbc = gbc;
    }

    public void enableInterrupts(boolean withDelay) {
        this.pendingDisableInterrupts = -1;
        if (withDelay) {
            if (this.pendingEnableInterrupts == -1) {
                this.pendingEnableInterrupts = 1;
            }
        } else {
            this.pendingEnableInterrupts = -1;
            this.ime = true;
        }
    }

    public void disableInterrupts(boolean withDelay) {
        this.pendingEnableInterrupts = -1;
        if (withDelay && this.gbc) {
            if (this.pendingDisableInterrupts == -1) {
                this.pendingDisableInterrupts = 1;
            }
        } else {
            this.pendingDisableInterrupts = -1;
            this.ime = false;
        }
    }

    public void requestInterrupt(InterruptType type) {
        this.interruptFlag |= 1 << type.ordinal();
    }

    public void clearInterrupt(InterruptType type) {
        this.interruptFlag &= ~(1 << type.ordinal());
    }

    public void onInstructionFinished() {
        if (this.pendingEnableInterrupts != -1 && this.pendingEnableInterrupts-- == 0) {
            this.enableInterrupts(false);
        }
        if (this.pendingDisableInterrupts != -1 && this.pendingDisableInterrupts-- == 0) {
            this.disableInterrupts(false);
        }
    }

    public boolean isIme() {
        return this.ime;
    }

    public boolean isInterruptRequested() {
        return (this.interruptFlag & this.interruptEnabled) != 0;
    }

    public boolean isHaltBug() {
        return (this.interruptFlag & this.interruptEnabled & 0x1F) != 0 && !this.ime;
    }

    @Override
    public boolean accepts(int address) {
        return address == 65295 || address == 65535;
    }

    @Override
    public void setByte(int address, int value) {
        switch (address) {
            case 65295: {
                this.interruptFlag = value | 0xE0;
                break;
            }
            case 65535: {
                this.interruptEnabled = value;
            }
        }
    }

    @Override
    public int getByte(int address) {
        switch (address) {
            case 65295: {
                return this.interruptFlag;
            }
            case 65535: {
                return this.interruptEnabled;
            }
        }
        return 255;
    }

    public static enum InterruptType {
        VBlank(64),
        LCDC(72),
        Timer(80),
        Serial(88),
        P10_13(96);

        private final int handler;

        private InterruptType(int handler) {
            this.handler = handler;
        }

        public int getHandler() {
            return this.handler;
        }
    }
}

