/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.cpu.opcode.Opcode;
import eu.rekawek.coffeegb.cpu.opcode.OpcodeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Opcodes {
    public static final List<Opcode> COMMANDS;
    public static final List<Opcode> EXT_COMMANDS;

    private Opcodes() {
    }

    private static OpcodeBuilder regLoad(OpcodeBuilder[] commands, int opcode, String target, String source) {
        return Opcodes.regCmd(commands, opcode, String.format("LD %s,%s", target, source)).copyByte(target, source);
    }

    private static OpcodeBuilder regCmd(OpcodeBuilder[] commands, int opcode, String label) {
        OpcodeBuilder builder;
        if (commands[opcode] != null) {
            throw new IllegalArgumentException(String.format("Opcode %02X already exists: %s", opcode, commands[opcode]));
        }
        commands[opcode] = builder = new OpcodeBuilder(opcode, label);
        return builder;
    }

    private static OpcodeBuilder regCmd(OpcodeBuilder[] commands, Map.Entry<Integer, String> opcode, String label) {
        return Opcodes.regCmd(commands, opcode.getKey(), label.replace("{}", opcode.getValue()));
    }

    private static <T> Iterable<Map.Entry<Integer, T>> indexedList(int start, int step, T ... values) {
        LinkedHashMap<Integer, T> map = new LinkedHashMap<Integer, T>();
        int i = start;
        for (T e : values) {
            map.put(i, e);
            i += step;
        }
        return map.entrySet();
    }

    static {
        OpcodeBuilder[] opcodes = new OpcodeBuilder[256];
        OpcodeBuilder[] extOpcodes = new OpcodeBuilder[256];
        Opcodes.regCmd(opcodes, 0, "NOP");
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(1, 16, "BC", "DE", "HL", "SP")) {
            Opcodes.regLoad(opcodes, t.getKey(), t.getValue(), "d16");
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(2, 16, "(BC)", "(DE)")) {
            Opcodes.regLoad(opcodes, t.getKey(), t.getValue(), "A");
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(3, 16, "BC", "DE", "HL", "SP")) {
            Opcodes.regCmd(opcodes, t, "INC {}").load(t.getValue()).alu("INC").store(t.getValue());
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(4, 8, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
            Opcodes.regCmd(opcodes, t, "INC {}").load(t.getValue()).alu("INC").store(t.getValue());
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(5, 8, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
            Opcodes.regCmd(opcodes, t, "DEC {}").load(t.getValue()).alu("DEC").store(t.getValue());
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(6, 8, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
            Opcodes.regLoad(opcodes, t.getKey(), t.getValue(), "d8");
        }
        for (Map.Entry<Integer, String> o : Opcodes.indexedList(7, 8, "RLC", "RRC", "RL", "RR")) {
            Opcodes.regCmd(opcodes, o, o.getValue() + "A").load("A").alu(o.getValue()).clearZ().store("A");
        }
        Opcodes.regLoad(opcodes, 8, "(a16)", "SP");
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(9, 16, "BC", "DE", "HL", "SP")) {
            Opcodes.regCmd(opcodes, t, "ADD HL,{}").load("HL").alu("ADD", t.getValue()).store("HL");
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(10, 16, "(BC)", "(DE)")) {
            Opcodes.regLoad(opcodes, t.getKey(), "A", t.getValue());
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(11, 16, "BC", "DE", "HL", "SP")) {
            Opcodes.regCmd(opcodes, t, "DEC {}").load(t.getValue()).alu("DEC").store(t.getValue());
        }
        Opcodes.regCmd(opcodes, 16, "STOP");
        Opcodes.regCmd(opcodes, 24, "JR r8").load("PC").alu("ADD", "r8").store("PC");
        for (Map.Entry<Integer, String> c : Opcodes.indexedList(32, 8, "NZ", "Z", "NC", "C")) {
            Opcodes.regCmd(opcodes, c, "JR {},r8").load("PC").proceedIf(c.getValue()).alu("ADD", "r8").store("PC");
        }
        Opcodes.regCmd(opcodes, 34, "LD (HL+),A").copyByte("(HL)", "A").aluHL("INC");
        Opcodes.regCmd(opcodes, 42, "LD A,(HL+)").copyByte("A", "(HL)").aluHL("INC");
        Opcodes.regCmd(opcodes, 39, "DAA").load("A").alu("DAA").store("A");
        Opcodes.regCmd(opcodes, 47, "CPL").load("A").alu("CPL").store("A");
        Opcodes.regCmd(opcodes, 50, "LD (HL-),A").copyByte("(HL)", "A").aluHL("DEC");
        Opcodes.regCmd(opcodes, 58, "LD A,(HL-)").copyByte("A", "(HL)").aluHL("DEC");
        Opcodes.regCmd(opcodes, 55, "SCF").load("A").alu("SCF").store("A");
        Opcodes.regCmd(opcodes, 63, "CCF").load("A").alu("CCF").store("A");
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(64, 8, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
            for (Map.Entry<Integer, String> s : Opcodes.indexedList(t.getKey(), 1, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
                if (s.getKey() == 118) continue;
                Opcodes.regLoad(opcodes, s.getKey(), t.getValue(), s.getValue());
            }
        }
        Opcodes.regCmd(opcodes, 118, "HALT");
        for (Map.Entry<Integer, String> o : Opcodes.indexedList(128, 8, "ADD", "ADC", "SUB", "SBC", "AND", "XOR", "OR", "CP")) {
            for (Map.Entry<Integer, String> t : Opcodes.indexedList(o.getKey(), 1, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
                Opcodes.regCmd(opcodes, t, o.getValue() + " {}").load("A").alu(o.getValue(), t.getValue()).store("A");
            }
        }
        for (Map.Entry<Integer, String> c : Opcodes.indexedList(192, 8, "NZ", "Z", "NC", "C")) {
            Opcodes.regCmd(opcodes, c, "RET {}").extraCycle().proceedIf(c.getValue()).pop().forceFinish().store("PC");
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(193, 16, "BC", "DE", "HL", "AF")) {
            Opcodes.regCmd(opcodes, t, "POP {}").pop().store(t.getValue());
        }
        for (Map.Entry<Integer, String> c : Opcodes.indexedList(194, 8, "NZ", "Z", "NC", "C")) {
            Opcodes.regCmd(opcodes, c, "JP {},a16").load("a16").proceedIf(c.getValue()).store("PC").extraCycle();
        }
        Opcodes.regCmd(opcodes, 195, "JP a16").load("a16").store("PC").extraCycle();
        for (Map.Entry<Integer, String> c : Opcodes.indexedList(196, 8, "NZ", "Z", "NC", "C")) {
            Opcodes.regCmd(opcodes, c, "CALL {},a16").proceedIf(c.getValue()).extraCycle().load("PC").push().load("a16").store("PC");
        }
        for (Map.Entry<Integer, String> t : Opcodes.indexedList(197, 16, "BC", "DE", "HL", "AF")) {
            Opcodes.regCmd(opcodes, t, "PUSH {}").extraCycle().load(t.getValue()).push();
        }
        for (Map.Entry<Integer, String> o : Opcodes.indexedList(198, 8, "ADD", "ADC", "SUB", "SBC", "AND", "XOR", "OR", "CP")) {
            Opcodes.regCmd(opcodes, o, o.getValue() + " d8").load("A").alu(o.getValue(), "d8").store("A");
        }
        int i = 199;
        int j = 0;
        while (i <= 247) {
            Opcodes.regCmd(opcodes, i, String.format("RST %02XH", j)).load("PC").push().forceFinish().loadWord(j).store("PC");
            i += 16;
            j += 16;
        }
        Opcodes.regCmd(opcodes, 201, "RET").pop().forceFinish().store("PC");
        Opcodes.regCmd(opcodes, 205, "CALL a16").load("PC").extraCycle().push().load("a16").store("PC");
        i = 207;
        j = 8;
        while (i <= 255) {
            Opcodes.regCmd(opcodes, i, String.format("RST %02XH", j)).load("PC").push().forceFinish().loadWord(j).store("PC");
            i += 16;
            j += 16;
        }
        Opcodes.regCmd(opcodes, 217, "RETI").pop().forceFinish().store("PC").switchInterrupts(true, false);
        Opcodes.regLoad(opcodes, 226, "(C)", "A");
        Opcodes.regLoad(opcodes, 242, "A", "(C)");
        Opcodes.regCmd(opcodes, 233, "JP (HL)").load("HL").store("PC");
        Opcodes.regCmd(opcodes, 224, "LDH (a8),A").copyByte("(a8)", "A");
        Opcodes.regCmd(opcodes, 240, "LDH A,(a8)").copyByte("A", "(a8)");
        Opcodes.regCmd(opcodes, 232, "ADD SP,r8").load("SP").alu("ADD_SP", "r8").extraCycle().store("SP");
        Opcodes.regCmd(opcodes, 248, "LD HL,SP+r8").load("SP").alu("ADD_SP", "r8").store("HL");
        Opcodes.regLoad(opcodes, 234, "(a16)", "A");
        Opcodes.regLoad(opcodes, 250, "A", "(a16)");
        Opcodes.regCmd(opcodes, 243, "DI").switchInterrupts(false, true);
        Opcodes.regCmd(opcodes, 251, "EI").switchInterrupts(true, true);
        Opcodes.regLoad(opcodes, 249, "SP", "HL").extraCycle();
        for (Map.Entry<Integer, String> o : Opcodes.indexedList(0, 8, "RLC", "RRC", "RL", "RR", "SLA", "SRA", "SWAP", "SRL")) {
            for (Map.Entry<Integer, String> t : Opcodes.indexedList(o.getKey(), 1, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
                Opcodes.regCmd(extOpcodes, t, o.getValue() + " {}").load(t.getValue()).alu(o.getValue()).store(t.getValue());
            }
        }
        for (Map.Entry<Integer, String> o : Opcodes.indexedList(64, 64, "BIT", "RES", "SET")) {
            for (int b = 0; b < 8; ++b) {
                for (Map.Entry<Integer, String> t : Opcodes.indexedList(o.getKey() + b * 8, 1, "B", "C", "D", "E", "H", "L", "(HL)", "A")) {
                    if ("BIT".equals(o.getValue()) && "(HL)".equals(t.getValue())) {
                        Opcodes.regCmd(extOpcodes, t, String.format("BIT %d,(HL)", b)).bitHL(b);
                        continue;
                    }
                    Opcodes.regCmd(extOpcodes, t, String.format("%s %d,%s", o.getValue(), b, t.getValue())).load(t.getValue()).alu(o.getValue(), b).store(t.getValue());
                }
            }
        }
        ArrayList<Opcode> commands = new ArrayList<Opcode>(256);
        ArrayList<Opcode> extCommands = new ArrayList<Opcode>(256);
        for (OpcodeBuilder b : opcodes) {
            if (b == null) {
                commands.add(null);
                continue;
            }
            commands.add(b.build());
        }
        for (OpcodeBuilder b : extOpcodes) {
            if (b == null) {
                extCommands.add(null);
                continue;
            }
            extCommands.add(b.build());
        }
        COMMANDS = Collections.unmodifiableList(commands);
        EXT_COMMANDS = Collections.unmodifiableList(extCommands);
    }
}

