/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.cpu.BitUtils;
import eu.rekawek.coffeegb.cpu.Flags;

public class Registers {
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int h;
    private int l;
    private int sp;
    private int pc;
    private Flags flags = new Flags();

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public int getC() {
        return this.c;
    }

    public int getD() {
        return this.d;
    }

    public int getE() {
        return this.e;
    }

    public int getH() {
        return this.h;
    }

    public int getL() {
        return this.l;
    }

    public int getAF() {
        return this.a << 8 | this.flags.getFlagsByte();
    }

    public int getBC() {
        return this.b << 8 | this.c;
    }

    public int getDE() {
        return this.d << 8 | this.e;
    }

    public int getHL() {
        return this.h << 8 | this.l;
    }

    public int getSP() {
        return this.sp;
    }

    public int getPC() {
        return this.pc;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public void setA(int a) {
        BitUtils.checkByteArgument("a", a);
        this.a = a;
    }

    public void setB(int b) {
        BitUtils.checkByteArgument("b", b);
        this.b = b;
    }

    public void setC(int c) {
        BitUtils.checkByteArgument("c", c);
        this.c = c;
    }

    public void setD(int d) {
        BitUtils.checkByteArgument("d", d);
        this.d = d;
    }

    public void setE(int e) {
        BitUtils.checkByteArgument("e", e);
        this.e = e;
    }

    public void setH(int h) {
        BitUtils.checkByteArgument("h", h);
        this.h = h;
    }

    public void setL(int l) {
        BitUtils.checkByteArgument("l", l);
        this.l = l;
    }

    public void setAF(int af) {
        BitUtils.checkWordArgument("af", af);
        this.a = BitUtils.getMSB(af);
        this.flags.setFlagsByte(BitUtils.getLSB(af));
    }

    public void setBC(int bc) {
        BitUtils.checkWordArgument("bc", bc);
        this.b = BitUtils.getMSB(bc);
        this.c = BitUtils.getLSB(bc);
    }

    public void setDE(int de) {
        BitUtils.checkWordArgument("de", de);
        this.d = BitUtils.getMSB(de);
        this.e = BitUtils.getLSB(de);
    }

    public void setHL(int hl) {
        BitUtils.checkWordArgument("hl", hl);
        this.h = BitUtils.getMSB(hl);
        this.l = BitUtils.getLSB(hl);
    }

    public void setSP(int sp) {
        BitUtils.checkWordArgument("sp", sp);
        this.sp = sp;
    }

    public void setPC(int pc) {
        BitUtils.checkWordArgument("pc", pc);
        this.pc = pc;
    }

    public void incrementPC() {
        this.pc = this.pc + 1 & 0xFFFF;
    }

    public void decrementSP() {
        this.sp = this.sp - 1 & 0xFFFF;
    }

    public void incrementSP() {
        this.sp = this.sp + 1 & 0xFFFF;
    }

    public String toString() {
        return String.format("AF=%04x, BC=%04x, DE=%04x, HL=%04x, SP=%04x, PC=%04x, %s", this.getAF(), this.getBC(), this.getDE(), this.getHL(), this.getSP(), this.getPC(), this.getFlags().toString());
    }
}

