/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import eu.rekawek.coffeegb.debug.CommandArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CommandPattern {
    private final List<String> commandNames;
    private final List<CommandArgument> arguments;
    private final Optional<String> description;

    private CommandPattern(Builder builder) {
        this.commandNames = builder.commandNames;
        this.arguments = builder.arguments;
        this.description = Optional.ofNullable(builder.description);
    }

    public boolean matches(String commandLine) {
        return this.commandNames.stream().filter(commandLine::startsWith).map(String::length).map(commandLine::substring).anyMatch(s -> s.isEmpty() || s.charAt(0) == ' ');
    }

    public List<String> getCommandNames() {
        return this.commandNames;
    }

    public List<CommandArgument> getArguments() {
        return this.arguments;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public ParsedCommandLine parse(String commandLine) {
        CommandArgument argDef;
        int i;
        String commandName = this.commandNames.stream().filter(commandLine::startsWith).findFirst().orElseThrow(() -> new IllegalArgumentException("Command line [" + commandLine + "] doesn't match command [" + this.commandNames + "]"));
        List<String> split = CommandPattern.split(commandLine.substring(commandName.length()));
        LinkedHashMap map = Maps.newLinkedHashMap();
        List<Object> remaining = Collections.emptyList();
        for (i = 0; i < split.size() && i < this.arguments.size(); ++i) {
            String value = split.get(i);
            CommandArgument argDef2 = this.arguments.get(i);
            Optional<Set<String>> allowed = argDef2.getAllowedValues();
            if (allowed.isPresent() && !allowed.get().contains(value)) {
                throw new IllegalArgumentException("Value " + value + " is not allowed for argument " + argDef2.getName() + ". Allowed values: " + allowed.get());
            }
            map.put(argDef2.getName(), value);
        }
        if (i < this.arguments.size() && (argDef = this.arguments.get(i)).isRequired()) {
            throw new IllegalArgumentException("Argument " + argDef.getName() + " is required");
        }
        if (i < split.size()) {
            remaining = split.subList(i, split.size());
        }
        return new ParsedCommandLine(map, remaining);
    }

    private static List<String> split(String str) {
        ArrayList<String> split = new ArrayList<String>();
        boolean isEscaped = false;
        StringBuilder currentArg = new StringBuilder();
        block8: for (int i = 0; i <= str.length(); ++i) {
            char c = i < str.length() ? str.charAt(i) : (char)'\u0000';
            if (isEscaped) {
                switch (c) {
                    case '\"': {
                        isEscaped = false;
                        split.add(currentArg.toString());
                        currentArg.setLength(0);
                        break;
                    }
                    case '\u0000': {
                        throw new IllegalArgumentException("Missing closing quote");
                    }
                    default: {
                        currentArg.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    isEscaped = false;
                    continue block8;
                }
                case '\u0000': 
                case ' ': {
                    if (currentArg.length() <= 0) continue block8;
                    split.add(currentArg.toString());
                    currentArg.setLength(0);
                    continue block8;
                }
                default: {
                    currentArg.append(c);
                }
            }
        }
        return split;
    }

    public String toString() {
        return String.format("CommandPattern[%s]", this.commandNames.toString());
    }

    public static class Builder {
        private final List<String> commandNames;
        private final List<CommandArgument> arguments;
        private String description;

        private Builder(String[] commandNames) {
            this.commandNames = ImmutableList.copyOf((Object[])commandNames);
            this.arguments = new ArrayList<CommandArgument>();
        }

        public static Builder create(String longName) {
            return new Builder(new String[]{longName});
        }

        public static Builder create(String longName, String shortName) {
            return new Builder(new String[]{longName, shortName});
        }

        public Builder withOptionalArgument(String name) {
            this.assertNoOptionalLastArgument();
            this.arguments.add(new CommandArgument(name, false));
            return this;
        }

        public Builder withRequiredArgument(String name) {
            this.assertNoOptionalLastArgument();
            this.arguments.add(new CommandArgument(name, true));
            return this;
        }

        public Builder withOptionalValue(String name, String ... values) {
            this.assertNoOptionalLastArgument();
            this.arguments.add(new CommandArgument(name, false, (Set<String>)ImmutableSet.copyOf((Object[])values)));
            return this;
        }

        public Builder withRequiredValue(String name, String ... values) {
            this.assertNoOptionalLastArgument();
            this.arguments.add(new CommandArgument(name, true, (Set<String>)ImmutableSet.copyOf((Object[])values)));
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        private void assertNoOptionalLastArgument() {
            if (!this.arguments.isEmpty() && !this.arguments.get(this.arguments.size() - 1).isRequired()) {
                throw new UnsupportedOperationException("Can't add argument after the optional one");
            }
        }

        public CommandPattern build() {
            return new CommandPattern(this);
        }
    }

    public static class ParsedCommandLine {
        private Map<String, String> argumentMap;
        private List<String> remainingArguments;

        private ParsedCommandLine(Map<String, String> argumentMap, List<String> remainingArguments) {
            this.argumentMap = argumentMap;
            this.remainingArguments = remainingArguments;
        }

        public String getArgument(String name) {
            return this.argumentMap.get(name);
        }

        public List<String> getRemainingArguments() {
            return this.remainingArguments;
        }
    }
}

