/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug.command.cpu;

import eu.rekawek.coffeegb.cpu.Opcodes;
import eu.rekawek.coffeegb.cpu.op.Op;
import eu.rekawek.coffeegb.cpu.opcode.Opcode;
import eu.rekawek.coffeegb.debug.Command;
import eu.rekawek.coffeegb.debug.CommandPattern;
import eu.rekawek.coffeegb.debug.ConsoleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class ShowOpcode
implements Command {
    private static final CommandPattern PATTERN = CommandPattern.Builder.create("cpu show opcode").withRequiredArgument("opcode").withDescription("displays opcode information for hex (0xFA) or name (LD A,B) identifier").build();

    @Override
    public CommandPattern getPattern() {
        return PATTERN;
    }

    @Override
    public void run(CommandPattern.ParsedCommandLine commandLine) {
        String arg = commandLine.getRemainingArguments().isEmpty() ? commandLine.getArgument("opcode") : commandLine.getArgument("opcode") + " " + String.join((CharSequence)" ", commandLine.getRemainingArguments());
        Opcode opcode = this.getOpcodeFromArg(arg);
        if (opcode == null) {
            System.out.println("Can't found opcode for " + arg);
            return;
        }
        boolean isExt = Opcodes.EXT_COMMANDS.get(opcode.getOpcode()) == opcode;
        ArrayList ops = new ArrayList();
        BiFunction<Integer, String, Boolean> addOp = (c, d) -> ops.add(new OpDescription((int)c, (String)d));
        if (isExt) {
            addOp.apply(4, "read opcode 0xCB");
        }
        addOp.apply(4, String.format("read opcode 0x%02X", opcode.getOpcode()));
        for (int i = 0; i < opcode.getOperandLength(); ++i) {
            addOp.apply(4, String.format("read operand %d", i + 1));
        }
        opcode.getOps().stream().map(OpDescription::new).forEach(ops::add);
        ArrayList<OpDescription> compacted = new ArrayList<OpDescription>();
        for (int i = 0; i < ops.size(); ++i) {
            OpDescription o2 = (OpDescription)ops.get(i);
            if (o2.description.equals("wait cycle")) {
                if (compacted.isEmpty()) continue;
                ((OpDescription)compacted.get(compacted.size() - 1)).updateCycles(4);
                continue;
            }
            if (o2.description.equals("finish cycle")) {
                if (i >= ops.size() - 1) continue;
                OpDescription nextOp = (OpDescription)ops.get(++i);
                nextOp.updateCycles(4);
                compacted.add(nextOp);
                continue;
            }
            compacted.add(o2);
        }
        int stringLength = compacted.stream().map(OpDescription::toString).map(String::length).mapToInt(Integer::valueOf).max().orElse(0);
        int totalCycles = compacted.stream().mapToInt(o -> ((OpDescription)o).cycles).sum();
        int totalCyclesUntilCondition = compacted.stream().filter(new Predicate<OpDescription>(){
            private boolean conditionalOccurred;

            @Override
            public boolean test(OpDescription opDescription) {
                this.conditionalOccurred = this.conditionalOccurred || opDescription.description.startsWith("? ");
                return !this.conditionalOccurred;
            }
        }).mapToInt(o -> ((OpDescription)o).cycles).sum();
        if (isExt) {
            System.out.println(String.format("0xCB%02X %s", opcode.getOpcode(), opcode.getLabel()));
        } else {
            System.out.println(String.format("0x%02X   %s", opcode.getOpcode(), opcode.getLabel()));
        }
        ConsoleUtil.printSeparator(stringLength);
        compacted.forEach(System.out::println);
        ConsoleUtil.printSeparator(stringLength);
        if (totalCyclesUntilCondition != totalCycles) {
            System.out.println(String.format("Total cycles: %d / %d", totalCycles, totalCyclesUntilCondition));
        } else {
            System.out.println(String.format("Total cycles: %d", totalCycles));
        }
    }

    private Opcode getOpcodeFromArg(String arg) {
        if (arg.toLowerCase().matches("0x[0-9a-f]{2}")) {
            return this.getFromHex(Opcodes.COMMANDS, arg.substring(2));
        }
        if (arg.toLowerCase().matches("0xcb[0-9a-f]{2}")) {
            return this.getFromHex(Opcodes.EXT_COMMANDS, arg.substring(4));
        }
        if (arg.toLowerCase().matches("[0-9a-f]{2}")) {
            return this.getFromHex(Opcodes.COMMANDS, arg);
        }
        if (arg.toLowerCase().matches("cb[0-9a-f]{2}")) {
            return this.getFromHex(Opcodes.EXT_COMMANDS, arg.substring(2));
        }
        String compactedArg = this.compactOpcodeLabel(arg);
        Optional<Opcode> opcode = Opcodes.COMMANDS.stream().filter(Objects::nonNull).filter(o -> compactedArg.equalsIgnoreCase(this.compactOpcodeLabel(o.getLabel()))).findFirst();
        if (!opcode.isPresent()) {
            opcode = Opcodes.EXT_COMMANDS.stream().filter(Objects::nonNull).filter(o -> compactedArg.equalsIgnoreCase(this.compactOpcodeLabel(o.getLabel()))).findFirst();
        }
        return opcode.orElse(null);
    }

    private Opcode getFromHex(List<Opcode> opcodes, String hexArg) {
        return opcodes.get(Integer.parseInt(hexArg, 16));
    }

    private String compactOpcodeLabel(String label) {
        return label.replace(" ", "").toLowerCase();
    }

    public static class OpDescription {
        private final String description;
        private int cycles;

        public OpDescription(Op op) {
            this.description = op.toString();
            if (op.writesMemory() || op.readsMemory()) {
                this.cycles = 4;
            }
        }

        public OpDescription(int cycles, String description) {
            this.description = description;
            this.cycles = cycles;
        }

        public void updateCycles(int cycles) {
            this.cycles += cycles;
        }

        public String toString() {
            return String.format("%s   %s", this.cycles == 0 ? " " : String.valueOf(this.cycles), this.description);
        }
    }
}

