/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import java.util.NoSuchElementException;

public class IntQueue {
    private final int[] array;
    private int size;
    private int offset = 0;

    public IntQueue(int capacity) {
        this.array = new int[capacity];
        this.size = 0;
        this.offset = 0;
    }

    public int size() {
        return this.size;
    }

    public void enqueue(int value) {
        if (this.size == this.array.length) {
            throw new IllegalStateException("Queue is full");
        }
        this.array[(this.offset + this.size) % this.array.length] = value;
        ++this.size;
    }

    public int dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty");
        }
        --this.size;
        int value = this.array[this.offset++];
        if (this.offset == this.array.length) {
            this.offset = 0;
        }
        return value;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[(this.offset + index) % this.array.length];
    }

    public void set(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[(this.offset + index) % this.array.length] = value;
    }

    public void clear() {
        this.size = 0;
        this.offset = 0;
    }
}

