/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.gpu.GpuRegister;

public class TileAttributes {
    public static final TileAttributes EMPTY;
    private static final TileAttributes[] ATTRIBUTES;
    private final int value;

    private TileAttributes(int value) {
        this.value = value;
    }

    public static TileAttributes valueOf(int value) {
        return ATTRIBUTES[value];
    }

    public boolean isPriority() {
        return (this.value & 0x80) != 0;
    }

    public boolean isYflip() {
        return (this.value & 0x40) != 0;
    }

    public boolean isXflip() {
        return (this.value & 0x20) != 0;
    }

    public GpuRegister getDmgPalette() {
        return (this.value & 0x10) == 0 ? GpuRegister.OBP0 : GpuRegister.OBP1;
    }

    public int getBank() {
        return (this.value & 8) == 0 ? 0 : 1;
    }

    public int getColorPaletteIndex() {
        return this.value & 7;
    }

    static {
        ATTRIBUTES = new TileAttributes[256];
        for (int i = 0; i < 256; ++i) {
            TileAttributes.ATTRIBUTES[i] = new TileAttributes(i);
        }
        EMPTY = ATTRIBUTES[0];
    }
}

