/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu.phase;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.phase.GpuPhase;
import eu.rekawek.coffeegb.memory.MemoryRegisters;

public class OamSearch
implements GpuPhase {
    private final AddressSpace oemRam;
    private final MemoryRegisters registers;
    private final SpritePosition[] sprites;
    private final Lcdc lcdc;
    private int spritePosIndex;
    private State state;
    private int spriteY;
    private int spriteX;
    private int i;

    public OamSearch(AddressSpace oemRam, Lcdc lcdc, MemoryRegisters registers) {
        this.oemRam = oemRam;
        this.registers = registers;
        this.lcdc = lcdc;
        this.sprites = new SpritePosition[10];
    }

    public OamSearch start() {
        this.spritePosIndex = 0;
        this.state = State.READING_Y;
        this.spriteY = 0;
        this.spriteX = 0;
        this.i = 0;
        for (int j = 0; j < this.sprites.length; ++j) {
            this.sprites[j] = null;
        }
        return this;
    }

    @Override
    public boolean tick() {
        int spriteAddress = 65024 + 4 * this.i;
        switch (this.state) {
            case READING_Y: {
                this.spriteY = this.oemRam.getByte(spriteAddress);
                this.state = State.READING_X;
                break;
            }
            case READING_X: {
                this.spriteX = this.oemRam.getByte(spriteAddress + 1);
                if (this.spritePosIndex < this.sprites.length && OamSearch.between(this.spriteY, this.registers.get(GpuRegister.LY) + 16, this.spriteY + this.lcdc.getSpriteHeight())) {
                    this.sprites[this.spritePosIndex++] = new SpritePosition(this.spriteX, this.spriteY, spriteAddress);
                }
                ++this.i;
                this.state = State.READING_Y;
            }
        }
        return this.i < 40;
    }

    public SpritePosition[] getSprites() {
        return this.sprites;
    }

    private static boolean between(int from, int x, int to) {
        return from <= x && x < to;
    }

    public static class SpritePosition {
        private final int x;
        private final int y;
        private final int address;

        public SpritePosition(int x, int y, int address) {
            this.x = x;
            this.y = y;
            this.address = address;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getAddress() {
            return this.address;
        }
    }

    private static enum State {
        READING_Y,
        READING_X;

    }
}

