/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gui;

import eu.rekawek.coffeegb.Gameboy;
import eu.rekawek.coffeegb.GameboyOptions;
import eu.rekawek.coffeegb.controller.Controller;
import eu.rekawek.coffeegb.cpu.SpeedMode;
import eu.rekawek.coffeegb.debug.Console;
import eu.rekawek.coffeegb.debug.IConsole;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gui.AudioSystemSoundOutput;
import eu.rekawek.coffeegb.gui.SwingController;
import eu.rekawek.coffeegb.gui.SwingDisplay;
import eu.rekawek.coffeegb.memory.cart.Cartridge;
import eu.rekawek.coffeegb.serial.SerialEndpoint;
import eu.rekawek.coffeegb.sound.SoundOutput;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Emulator {
    private static final int SCALE = 2;
    private final GameboyOptions options;
    private final Cartridge rom;
    private final SoundOutput sound;
    private final Display display;
    private final SwingController controller;
    private final SerialEndpoint serialEndpoint;
    private final SpeedMode speedMode;
    private final Gameboy gameboy;
    private final Optional<IConsole> console;
    private JFrame mainWindow;

    public Emulator(String[] args, Display disp, SoundOutput soundOutput, SwingController controller) throws IOException {
        this.options = Emulator.parseArgs(args);
        this.rom = new Cartridge(this.options);
        this.speedMode = new SpeedMode();
        this.serialEndpoint = SerialEndpoint.NULL_ENDPOINT;
        this.console = Optional.empty();
        this.console.map(Thread::new).ifPresent(Thread::start);
        if (this.options.isHeadless()) {
            this.sound = null;
            this.display = null;
            this.controller = null;
            this.gameboy = new Gameboy(this.options, this.rom, Display.NULL_DISPLAY, Controller.NULL_CONTROLLER, SoundOutput.NULL_OUTPUT, this.serialEndpoint, this.console);
        } else {
            this.sound = soundOutput;
            this.controller = controller;
            this.display = disp;
            this.display.addKeyListener(controller);
            this.gameboy = new Gameboy(this.options, this.rom, this.display, controller, this.sound, this.serialEndpoint, this.console);
        }
        this.console.ifPresent(c -> c.init(this.gameboy));
    }

    public Emulator(String[] args, Properties properties) throws IOException {
        this.options = Emulator.parseArgs(args);
        this.rom = new Cartridge(this.options);
        this.speedMode = new SpeedMode();
        this.serialEndpoint = SerialEndpoint.NULL_ENDPOINT;
        this.console = this.options.isDebug() ? Optional.of(new Console()) : Optional.empty();
        this.console.map(Thread::new).ifPresent(Thread::start);
        if (this.options.isHeadless()) {
            this.sound = null;
            this.display = null;
            this.controller = null;
            this.gameboy = new Gameboy(this.options, this.rom, Display.NULL_DISPLAY, Controller.NULL_CONTROLLER, SoundOutput.NULL_OUTPUT, this.serialEndpoint, this.console);
        } else {
            this.sound = new AudioSystemSoundOutput();
            this.controller = SwingController.createController(properties);
            this.display = new SwingDisplay(2);
            this.display.addKeyListener(this.controller);
            this.gameboy = new Gameboy(this.options, this.rom, this.display, this.controller, this.sound, this.serialEndpoint, this.console);
        }
        this.console.ifPresent(c -> c.init(this.gameboy));
    }

    private static GameboyOptions parseArgs(String[] args) {
        if (args.length == 0) {
            GameboyOptions.printUsage(System.out);
            System.exit(0);
            return null;
        }
        try {
            return Emulator.createGameboyOptions(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println();
            GameboyOptions.printUsage(System.err);
            System.exit(1);
            return null;
        }
    }

    private static GameboyOptions createGameboyOptions(String[] args) {
        HashSet<String> params = new HashSet<String>();
        HashSet<String> shortParams = new HashSet<String>();
        String romPath = null;
        for (String a : args) {
            if (a.startsWith("--")) {
                params.add(a.substring(2));
                continue;
            }
            if (a.startsWith("-")) {
                shortParams.add(a.substring(1));
                continue;
            }
            romPath = a;
        }
        if (romPath == null) {
            throw new IllegalArgumentException("ROM path hasn't been specified");
        }
        File romFile = new File(romPath);
        if (!romFile.exists()) {
            throw new IllegalArgumentException("The ROM path doesn't exist: " + romPath);
        }
        return new GameboyOptions(romFile, params, shortParams);
    }

    public void run() throws Exception {
        if (this.options.isHeadless()) {
            this.gameboy.run();
        } else {
            System.setProperty("sun.java2d.opengl", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(() -> this.startGui());
        }
    }

    public void runOnCurrentThread() {
        this.gameboy.run();
    }

    public void stop() {
        this.gameboy.stop();
    }

    private void startGui() {
        Optional<Object> swingDisplay = Optional.empty();
        if (this.display instanceof SwingDisplay) {
            swingDisplay = Optional.of((SwingDisplay)this.display);
        }
        swingDisplay.ifPresent(d -> d.setPreferredSize(new Dimension(320, 288)));
        this.mainWindow = new JFrame("Coffee GB: " + this.rom.getTitle());
        this.mainWindow.setDefaultCloseOperation(3);
        this.mainWindow.setLocationRelativeTo(null);
        swingDisplay.ifPresent(this.mainWindow::setContentPane);
        this.mainWindow.setResizable(false);
        this.mainWindow.setVisible(true);
        this.mainWindow.pack();
        this.mainWindow.addKeyListener(this.controller);
        swingDisplay.ifPresent(d -> new Thread((Runnable)d).start());
        new Thread(this.gameboy).start();
    }

    private void stopGui() {
        this.display.stop();
        this.gameboy.stop();
        this.mainWindow.dispose();
    }
}

