/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.SpeedMode;
import eu.rekawek.coffeegb.memory.DmaAddressSpace;

public class Dma
implements AddressSpace {
    private final AddressSpace addressSpace;
    private final AddressSpace oam;
    private final SpeedMode speedMode;
    private boolean transferInProgress;
    private boolean restarted;
    private int from;
    private int ticks;
    private int regValue = 255;

    public Dma(AddressSpace addressSpace, AddressSpace oam, SpeedMode speedMode) {
        this.addressSpace = new DmaAddressSpace(addressSpace);
        this.speedMode = speedMode;
        this.oam = oam;
    }

    @Override
    public boolean accepts(int address) {
        return address == 65350;
    }

    public void tick() {
        if (this.transferInProgress && ++this.ticks >= 648 / this.speedMode.getSpeedMode()) {
            this.transferInProgress = false;
            this.restarted = false;
            this.ticks = 0;
            for (int i = 0; i < 160; ++i) {
                this.oam.setByte(65024 + i, this.addressSpace.getByte(this.from + i));
            }
        }
    }

    @Override
    public void setByte(int address, int value) {
        this.from = value * 256;
        this.restarted = this.isOamBlocked();
        this.ticks = 0;
        this.transferInProgress = true;
        this.regValue = value;
    }

    @Override
    public int getByte(int address) {
        return this.regValue;
    }

    public boolean isOamBlocked() {
        return this.restarted || this.transferInProgress && this.ticks >= 5;
    }
}

