/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.memory.Ram;

public class UndocumentedGbcRegisters
implements AddressSpace {
    private Ram ram = new Ram(65394, 6);
    private int xff6c = 254;

    public UndocumentedGbcRegisters() {
        this.ram.setByte(65396, 255);
        this.ram.setByte(65397, 143);
    }

    @Override
    public boolean accepts(int address) {
        return address == 65388 || this.ram.accepts(address);
    }

    @Override
    public void setByte(int address, int value) {
        switch (address) {
            case 65388: {
                this.xff6c = 0xFE | value & 1;
                break;
            }
            case 65394: 
            case 65395: 
            case 65396: {
                this.ram.setByte(address, value);
                break;
            }
            case 65397: {
                this.ram.setByte(address, 0x8F | value & 0x70);
            }
        }
    }

    @Override
    public int getByte(int address) {
        if (address == 65388) {
            return this.xff6c;
        }
        if (this.ram.accepts(address)) {
            return this.ram.getByte(address);
        }
        throw new IllegalArgumentException();
    }
}

