/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart;

import java.util.regex.Pattern;

public enum CartridgeType {
    ROM(0),
    ROM_MBC1(1),
    ROM_MBC1_RAM(2),
    ROM_MBC1_RAM_BATTERY(3),
    ROM_MBC2(5),
    ROM_MBC2_BATTERY(6),
    ROM_RAM(8),
    ROM_RAM_BATTERY(9),
    ROM_MMM01(11),
    ROM_MMM01_SRAM(12),
    ROM_MMM01_SRAM_BATTERY(13),
    ROM_MBC3_TIMER_BATTERY(15),
    ROM_MBC3_TIMER_RAM_BATTERY(16),
    ROM_MBC3(17),
    ROM_MBC3_RAM(18),
    ROM_MBC3_RAM_BATTERY(19),
    ROM_MBC5(25),
    ROM_MBC5_RAM(26),
    ROM_MBC5_RAM_BATTERY(27),
    ROM_MBC5_RUMBLE(28),
    ROM_MBC5_RUMBLE_SRAM(29),
    ROM_MBC5_RUMBLE_SRAM_BATTERY(30);

    private final int id;

    private CartridgeType(int id) {
        this.id = id;
    }

    public boolean isMbc1() {
        return this.nameContainsSegment("MBC1");
    }

    public boolean isMbc2() {
        return this.nameContainsSegment("MBC2");
    }

    public boolean isMbc3() {
        return this.nameContainsSegment("MBC3");
    }

    public boolean isMbc5() {
        return this.nameContainsSegment("MBC5");
    }

    public boolean isMmm01() {
        return this.nameContainsSegment("MMM01");
    }

    public boolean isRam() {
        return this.nameContainsSegment("RAM");
    }

    public boolean isSram() {
        return this.nameContainsSegment("SRAM");
    }

    public boolean isTimer() {
        return this.nameContainsSegment("TIMER");
    }

    public boolean isBattery() {
        return this.nameContainsSegment("BATTERY");
    }

    public boolean isRumble() {
        return this.nameContainsSegment("RUMBLE");
    }

    private boolean nameContainsSegment(String segment) {
        Pattern p = Pattern.compile("(^|_)" + Pattern.quote(segment) + "($|_)");
        return p.matcher(this.name()).find();
    }

    public static CartridgeType getById(int id) {
        for (CartridgeType t : CartridgeType.values()) {
            if (t.id != id) continue;
            return t;
        }
        throw new IllegalArgumentException("Unsupported cartridge type: " + Integer.toHexString(id));
    }
}

