/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart.type;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.memory.cart.CartridgeType;
import eu.rekawek.coffeegb.memory.cart.battery.Battery;

public class Mbc2
implements AddressSpace {
    private final CartridgeType type;
    private final int romBanks;
    private final int[] cartridge;
    private final int[] ram;
    private final Battery battery;
    private int selectedRomBank = 1;
    private boolean ramWriteEnabled;

    public Mbc2(int[] cartridge, CartridgeType type, Battery battery, int romBanks) {
        this.cartridge = cartridge;
        this.romBanks = romBanks;
        this.ram = new int[512];
        for (int i = 0; i < this.ram.length; ++i) {
            this.ram[i] = 255;
        }
        this.type = type;
        this.battery = battery;
        battery.loadRam(this.ram);
    }

    @Override
    public boolean accepts(int address) {
        return address >= 0 && address < 32768 || address >= 40960 && address < 49152;
    }

    @Override
    public void setByte(int address, int value) {
        int ramAddress;
        if (address >= 0 && address < 8192) {
            if ((address & 0x100) == 0) {
                boolean bl = this.ramWriteEnabled = (value & 0xA) != 0;
                if (!this.ramWriteEnabled) {
                    this.battery.saveRam(this.ram);
                }
            }
        } else if (address >= 8192 && address < 16384) {
            if ((address & 0x100) != 0) {
                this.selectedRomBank = value & 0xF;
            }
        } else if (address >= 40960 && address < 49152 && this.ramWriteEnabled && (ramAddress = this.getRamAddress(address)) < this.ram.length) {
            this.ram[ramAddress] = value & 0xF;
        }
    }

    @Override
    public int getByte(int address) {
        if (address >= 0 && address < 16384) {
            return this.getRomByte(0, address);
        }
        if (address >= 16384 && address < 32768) {
            return this.getRomByte(this.selectedRomBank, address - 16384);
        }
        if (address >= 40960 && address < 45056) {
            int ramAddress = this.getRamAddress(address);
            if (ramAddress < this.ram.length) {
                return this.ram[ramAddress];
            }
            return 255;
        }
        return 255;
    }

    private int getRomByte(int bank, int address) {
        int cartOffset = bank * 16384 + address;
        if (cartOffset < this.cartridge.length) {
            return this.cartridge[cartOffset];
        }
        return 255;
    }

    private int getRamAddress(int address) {
        return address - 40960;
    }
}

