/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

public class FrequencySweep {
    private static final int DIVIDER = 32768;
    private int period;
    private boolean negate;
    private int shift;
    private int timer;
    private int shadowFreq;
    private int nr13;
    private int nr14;
    private int i;
    private boolean overflow;
    private boolean counterEnabled;
    private boolean negging;

    public void start() {
        this.counterEnabled = false;
        this.i = 8192;
    }

    public void trigger() {
        this.negging = false;
        this.overflow = false;
        this.shadowFreq = this.nr13 | (this.nr14 & 7) << 8;
        this.timer = this.period == 0 ? 8 : this.period;
        boolean bl = this.counterEnabled = this.period != 0 || this.shift != 0;
        if (this.shift > 0) {
            this.calculate();
        }
    }

    public void setNr10(int value) {
        this.period = value >> 4 & 7;
        this.negate = (value & 8) != 0;
        this.shift = value & 7;
        if (this.negging && !this.negate) {
            this.overflow = true;
        }
    }

    public void setNr13(int value) {
        this.nr13 = value;
    }

    public void setNr14(int value) {
        this.nr14 = value;
        if ((value & 0x80) != 0) {
            this.trigger();
        }
    }

    public int getNr13() {
        return this.nr13;
    }

    public int getNr14() {
        return this.nr14;
    }

    public void tick() {
        if (++this.i == 32768) {
            this.i = 0;
            if (!this.counterEnabled) {
                return;
            }
            if (--this.timer == 0) {
                int n = this.timer = this.period == 0 ? 8 : this.period;
                if (this.period != 0) {
                    int newFreq = this.calculate();
                    if (!this.overflow && this.shift != 0) {
                        this.shadowFreq = newFreq;
                        this.nr13 = this.shadowFreq & 0xFF;
                        this.nr14 = (this.shadowFreq & 0x700) >> 8;
                        this.calculate();
                    }
                }
            }
        }
    }

    private int calculate() {
        int freq = this.shadowFreq >> this.shift;
        if (this.negate) {
            freq = this.shadowFreq - freq;
            this.negging = true;
        } else {
            freq = this.shadowFreq + freq;
        }
        if (freq > 2047) {
            this.overflow = true;
        }
        return freq;
    }

    public boolean isEnabled() {
        return !this.overflow;
    }
}

