/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.memory.Ram;
import eu.rekawek.coffeegb.sound.AbstractSoundMode;
import eu.rekawek.coffeegb.sound.SoundMode1;
import eu.rekawek.coffeegb.sound.SoundMode2;
import eu.rekawek.coffeegb.sound.SoundMode3;
import eu.rekawek.coffeegb.sound.SoundMode4;
import eu.rekawek.coffeegb.sound.SoundOutput;

public class Sound
implements AddressSpace {
    private static final int[] MASKS = new int[]{128, 63, 0, 255, 191, 255, 63, 0, 255, 191, 127, 255, 159, 255, 191, 255, 255, 0, 0, 191, 0, 0, 112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final AbstractSoundMode[] allModes = new AbstractSoundMode[4];
    private final Ram r = new Ram(65316, 3);
    private final SoundOutput output;
    private int[] channels = new int[4];
    private boolean enabled;
    private boolean[] overridenEnabled = new boolean[]{true, true, true, true};

    public Sound(SoundOutput output, boolean gbc) {
        this.allModes[0] = new SoundMode1(gbc);
        this.allModes[1] = new SoundMode2(gbc);
        this.allModes[2] = new SoundMode3(gbc);
        this.allModes[3] = new SoundMode4(gbc);
        this.output = output;
    }

    public void tick() {
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < this.allModes.length; ++i) {
            AbstractSoundMode m = this.allModes[i];
            this.channels[i] = m.tick();
        }
        int selection = this.r.getByte(65317);
        int left = 0;
        int right = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.overridenEnabled[i]) continue;
            if ((selection & 1 << i + 4) != 0) {
                left += this.channels[i];
            }
            if ((selection & 1 << i) == 0) continue;
            right += this.channels[i];
        }
        left /= 4;
        right /= 4;
        int volumes = this.r.getByte(65316);
        this.output.play((byte)(left *= volumes >> 4 & 7), (byte)(right *= volumes & 7));
    }

    private AddressSpace getAddressSpace(int address) {
        for (AbstractSoundMode m : this.allModes) {
            if (!m.accepts(address)) continue;
            return m;
        }
        if (this.r.accepts(address)) {
            return this.r;
        }
        return null;
    }

    @Override
    public boolean accepts(int address) {
        return this.getAddressSpace(address) != null;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == 65318) {
            if ((value & 0x80) == 0) {
                if (this.enabled) {
                    this.enabled = false;
                    this.stop();
                }
            } else if (!this.enabled) {
                this.enabled = true;
                this.start();
            }
            return;
        }
        AddressSpace s = this.getAddressSpace(address);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s.setByte(address, value);
    }

    @Override
    public int getByte(int address) {
        int result;
        if (address == 65318) {
            result = 0;
            for (int i = 0; i < this.allModes.length; ++i) {
                result |= this.allModes[i].isEnabled() ? 1 << i : 0;
            }
            result |= this.enabled ? 128 : 0;
        } else {
            result = this.getUnmaskedByte(address);
        }
        return result | MASKS[address - 65296];
    }

    private int getUnmaskedByte(int address) {
        AddressSpace s = this.getAddressSpace(address);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s.getByte(address);
    }

    private void start() {
        for (int i = 65296; i <= 65317; ++i) {
            int v = 0;
            if (i == 65297 || i == 65302 || i == 65312) {
                v = this.getUnmaskedByte(i) & 0x3F;
            } else if (i == 65307) {
                v = this.getUnmaskedByte(i);
            }
            this.setByte(i, v);
        }
        for (AbstractSoundMode m : this.allModes) {
            m.start();
        }
        this.output.start();
    }

    private void stop() {
        this.output.stop();
        for (AbstractSoundMode s : this.allModes) {
            s.stop();
        }
    }

    public void enableChannel(int i, boolean enabled) {
        this.overridenEnabled[i] = enabled;
    }
}

