/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

import eu.rekawek.coffeegb.memory.Ram;
import eu.rekawek.coffeegb.sound.AbstractSoundMode;

public class SoundMode3
extends AbstractSoundMode {
    private static final int[] DMG_WAVE = new int[]{132, 64, 67, 170, 45, 120, 146, 60, 96, 89, 89, 176, 52, 184, 46, 218};
    private static final int[] CGB_WAVE = new int[]{0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255};
    private final Ram waveRam = new Ram(65328, 16);
    private int freqDivider;
    private int lastOutput;
    private int i;
    private int ticksSinceRead = 65536;
    private int lastReadAddr;
    private int buffer;
    private boolean triggered;

    public SoundMode3(boolean gbc) {
        super(65306, 256, gbc);
        for (int v : gbc ? CGB_WAVE : DMG_WAVE) {
            this.waveRam.setByte(65328, v);
        }
    }

    @Override
    public boolean accepts(int address) {
        return this.waveRam.accepts(address) || super.accepts(address);
    }

    @Override
    public int getByte(int address) {
        if (!this.waveRam.accepts(address)) {
            return super.getByte(address);
        }
        if (!this.isEnabled()) {
            return this.waveRam.getByte(address);
        }
        if (this.waveRam.accepts(this.lastReadAddr) && (this.gbc || this.ticksSinceRead < 2)) {
            return this.waveRam.getByte(this.lastReadAddr);
        }
        return 255;
    }

    @Override
    public void setByte(int address, int value) {
        if (!this.waveRam.accepts(address)) {
            super.setByte(address, value);
            return;
        }
        if (!this.isEnabled()) {
            this.waveRam.setByte(address, value);
        } else if (this.waveRam.accepts(this.lastReadAddr) && (this.gbc || this.ticksSinceRead < 2)) {
            this.waveRam.setByte(this.lastReadAddr, value);
        }
    }

    @Override
    protected void setNr0(int value) {
        super.setNr0(value);
        this.dacEnabled = (value & 0x80) != 0;
        this.channelEnabled &= this.dacEnabled;
    }

    @Override
    protected void setNr1(int value) {
        super.setNr1(value);
        this.length.setLength(256 - value);
    }

    @Override
    protected void setNr3(int value) {
        super.setNr3(value);
    }

    @Override
    public void setNr4(int value) {
        if (!this.gbc && (value & 0x80) != 0 && this.isEnabled() && this.freqDivider == 2) {
            int pos = this.i / 2;
            if (pos < 4) {
                this.waveRam.setByte(65328, this.waveRam.getByte(65328 + pos));
            } else {
                pos &= 0xFFFFFFFC;
                for (int j = 0; j < 4; ++j) {
                    this.waveRam.setByte(65328 + j, this.waveRam.getByte(65328 + (pos + j) % 16));
                }
            }
        }
        super.setNr4(value);
    }

    @Override
    public void start() {
        this.i = 0;
        this.buffer = 0;
        if (this.gbc) {
            this.length.reset();
        }
        this.length.start();
    }

    @Override
    public void trigger() {
        this.i = 0;
        this.freqDivider = 6;
        boolean bl = this.triggered = !this.gbc;
        if (this.gbc) {
            this.getWaveEntry();
        }
    }

    @Override
    public int tick() {
        ++this.ticksSinceRead;
        if (!this.updateLength()) {
            return 0;
        }
        if (!this.dacEnabled) {
            return 0;
        }
        if ((this.getNr0() & 0x80) == 0) {
            return 0;
        }
        if (--this.freqDivider == 0) {
            this.resetFreqDivider();
            if (this.triggered) {
                this.lastOutput = this.buffer >> 4 & 0xF;
                this.triggered = false;
            } else {
                this.lastOutput = this.getWaveEntry();
            }
            this.i = (this.i + 1) % 32;
        }
        return this.lastOutput;
    }

    private int getVolume() {
        return this.getNr2() >> 5 & 3;
    }

    private int getWaveEntry() {
        this.ticksSinceRead = 0;
        this.lastReadAddr = 65328 + this.i / 2;
        int b = this.buffer = this.waveRam.getByte(this.lastReadAddr);
        b = this.i % 2 == 0 ? b >> 4 & 0xF : (b &= 0xF);
        switch (this.getVolume()) {
            case 0: {
                return 0;
            }
            case 1: {
                return b;
            }
            case 2: {
                return b >> 1;
            }
            case 3: {
                return b >> 2;
            }
        }
        throw new IllegalStateException();
    }

    private void resetFreqDivider() {
        this.freqDivider = this.getFrequency() * 2;
    }
}

