/*
 * Decompiled with CFR 0.152.
 */
package com.github.trilarion.sound.sampled.spi;

import com.github.trilarion.sound.sampled.AudioFormats;
import com.github.trilarion.sound.sampled.spi.SimpleFormatConversionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public abstract class MatrixFormatConversionProvider
extends SimpleFormatConversionProvider {
    private static final Logger LOG = Logger.getLogger(MatrixFormatConversionProvider.class.getName());
    private final Map<AudioFormat, List<AudioFormat.Encoding>> m_targetEncodingsFromSourceFormat = new HashMap<AudioFormat, List<AudioFormat.Encoding>>();
    private final Map<AudioFormat, Map<AudioFormat.Encoding, Collection<AudioFormat>>> m_targetFormatsFromSourceFormat = new HashMap<AudioFormat, Map<AudioFormat.Encoding, Collection<AudioFormat>>>();

    protected MatrixFormatConversionProvider(List<AudioFormat> sourceFormats, List<AudioFormat> targetFormats, boolean[][] abConversionPossible) {
        super(sourceFormats, targetFormats);
        for (int nSourceFormat = 0; nSourceFormat < sourceFormats.size(); ++nSourceFormat) {
            AudioFormat sourceFormat = sourceFormats.get(nSourceFormat);
            ArrayList<AudioFormat.Encoding> supportedTargetEncodings = new ArrayList<AudioFormat.Encoding>();
            this.m_targetEncodingsFromSourceFormat.put(sourceFormat, supportedTargetEncodings);
            HashMap<AudioFormat.Encoding, ArrayList<AudioFormat>> targetFormatsFromTargetEncodings = new HashMap<AudioFormat.Encoding, ArrayList<AudioFormat>>();
            this.m_targetFormatsFromSourceFormat.put(sourceFormat, targetFormatsFromTargetEncodings);
            for (int nTargetFormat = 0; nTargetFormat < targetFormats.size(); ++nTargetFormat) {
                AudioFormat targetFormat = targetFormats.get(nTargetFormat);
                if (!abConversionPossible[nSourceFormat][nTargetFormat]) continue;
                AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
                supportedTargetEncodings.add(targetEncoding);
                ArrayList<AudioFormat> supportedTargetFormats = (ArrayList<AudioFormat>)targetFormatsFromTargetEncodings.get(targetEncoding);
                if (supportedTargetFormats == null) {
                    supportedTargetFormats = new ArrayList<AudioFormat>();
                    targetFormatsFromTargetEncodings.put(targetEncoding, supportedTargetFormats);
                }
                supportedTargetFormats.add(targetFormat);
            }
        }
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        for (Map.Entry<AudioFormat, List<AudioFormat.Encoding>> entry : this.m_targetEncodingsFromSourceFormat.entrySet()) {
            AudioFormat format = entry.getKey();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            List<AudioFormat.Encoding> targetEncodings = entry.getValue();
            return targetEncodings.toArray(EMPTY_ENCODING_ARRAY);
        }
        return EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        for (Map.Entry<AudioFormat, Map<AudioFormat.Encoding, Collection<AudioFormat>>> entry : this.m_targetFormatsFromSourceFormat.entrySet()) {
            AudioFormat format = entry.getKey();
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            Map<AudioFormat.Encoding, Collection<AudioFormat>> targetEncodings = entry.getValue();
            Collection<AudioFormat> targetFormats = targetEncodings.get(targetEncoding);
            if (targetFormats != null) {
                return targetFormats.toArray(EMPTY_FORMAT_ARRAY);
            }
            return EMPTY_FORMAT_ARRAY;
        }
        return EMPTY_FORMAT_ARRAY;
    }
}

