/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers;

import java.util.Iterator;
import org.jaudiolibs.audioservers.util.ObjectLookup;

public final class AudioConfiguration {
    private final float sampleRate;
    private final int inputChannelCount;
    private final int outputChannelCount;
    private final int maxBufferSize;
    private final boolean fixedBufferSize;
    private final ObjectLookup lookup;

    public AudioConfiguration(float sampleRate, int inputChannelCount, int outputChannelCount, int bufferSize, Object ... exts) {
        this(sampleRate, inputChannelCount, outputChannelCount, bufferSize, true, exts);
    }

    public AudioConfiguration(float sampleRate, int inputChannelCount, int outputChannelCount, int maxBufferSize, boolean fixedBufferSize, Object ... exts) {
        this.sampleRate = AudioConfiguration.validate(sampleRate, 1.0f);
        this.inputChannelCount = AudioConfiguration.validate(inputChannelCount, 0);
        this.outputChannelCount = AudioConfiguration.validate(outputChannelCount, 0);
        this.maxBufferSize = AudioConfiguration.validate(maxBufferSize, 1);
        this.fixedBufferSize = fixedBufferSize;
        this.lookup = exts == null || exts.length == 0 ? ObjectLookup.EMPTY : new ObjectLookup(exts);
    }

    public AudioConfiguration(float sampleRate, int inputChannelCount, int outputChannelCount, int maxBufferSize, boolean fixedBufferSize) {
        this(sampleRate, inputChannelCount, outputChannelCount, maxBufferSize, fixedBufferSize, (Object[])null);
    }

    private static float validate(float value, float minimum) {
        if (value < minimum) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    private static int validate(int value, int minimum) {
        if (value < minimum) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public boolean isFixedBufferSize() {
        return this.fixedBufferSize;
    }

    public int getInputChannelCount() {
        return this.inputChannelCount;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getOutputChannelCount() {
        return this.outputChannelCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public <T> T find(Class<T> type) {
        return this.lookup.find(type);
    }

    public <T> Iterable<T> findAll(Class<T> type) {
        return this.lookup.findAll(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Audio Configuration --- \n");
        sb.append("Sample Rate : ").append(this.sampleRate).append('\n');
        sb.append("Input Channels : ").append(this.inputChannelCount).append('\n');
        sb.append("Output Channels : ").append(this.outputChannelCount).append('\n');
        sb.append("Max Buffer Size : ").append(this.maxBufferSize).append('\n');
        sb.append("Fixed Buffer Size : ").append(this.fixedBufferSize).append('\n');
        Iterator<Object> exts = this.findAll(Object.class).iterator();
        if (exts.hasNext()) {
            sb.append("Extensions -\n");
            do {
                Object o = exts.next();
                sb.append(" -- ").append(o).append(" (").append(o.getClass()).append(")\n");
            } while (exts.hasNext());
        }
        return sb.toString();
    }
}

