/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.ext;

import java.util.Collections;

public abstract class Device {
    private final String name;
    private final int maxInputChannels;
    private final int maxOutputChannels;

    public Device(String name, int maxInputChannels, int maxOutputChannels) {
        if (name == null) {
            throw new NullPointerException("Name parameter cannot be null");
        }
        this.name = name;
        if (maxInputChannels < 0 || maxOutputChannels < 0) {
            throw new IllegalArgumentException("Channel count cannot be less than zero");
        }
        this.maxInputChannels = maxInputChannels;
        this.maxOutputChannels = maxOutputChannels;
    }

    public final String getName() {
        return this.name;
    }

    public final int getMaxInputChannels() {
        return this.maxInputChannels;
    }

    public final int getMaxOutputChannels() {
        return this.maxOutputChannels;
    }

    public <T> T find(Class<T> type) {
        return null;
    }

    public <T> Iterable<T> findAll(Class<T> type) {
        return Collections.emptyList();
    }

    public String toString() {
        return this.name;
    }
}

