/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.util;

import java.util.ArrayList;

public final class ObjectLookup {
    public static final ObjectLookup EMPTY = new ObjectLookup(new Object[0]);
    private final ObjectLookup parent;
    private final Object[] objs;

    public ObjectLookup(Object ... objs) {
        this(null, objs);
    }

    public ObjectLookup(ObjectLookup parent, Object ... objs) {
        for (Object o : objs) {
            if (o != null) continue;
            throw new NullPointerException();
        }
        this.parent = parent;
        this.objs = (Object[])objs.clone();
    }

    public <T> T find(Class<T> type) {
        for (Object obj : this.objs) {
            if (!type.isInstance(obj)) continue;
            return type.cast(obj);
        }
        return this.parent == null ? null : (T)this.parent.find(type);
    }

    public <T> Iterable<T> findAll(Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : this.objs) {
            if (!type.isInstance(obj)) continue;
            list.add(type.cast(obj));
        }
        if (this.parent != null) {
            for (Object obj : this.parent.findAll(type)) {
                list.add(obj);
            }
        }
        return list;
    }
}

