/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.cpu.BitUtils;
import eu.rekawek.coffeegb.cpu.Flags;
import eu.rekawek.coffeegb.cpu.op.DataType;
import java.util.HashMap;
import java.util.Map;

public class AluFunctions {
    private Map<FunctionKey, IntRegistryFunction> functions = new HashMap<FunctionKey, IntRegistryFunction>();
    private Map<FunctionKey, BiIntRegistryFunction> biFunctions = new HashMap<FunctionKey, BiIntRegistryFunction>();

    public AluFunctions() {
        this.registerAluFunction("INC", DataType.D8, (flags, arg) -> {
            int result = arg + 1 & 0xFF;
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH((arg & 0xF) == 15);
            return result;
        });
        this.registerAluFunction("INC", DataType.D16, (flags, arg) -> arg + 1 & 0xFFFF);
        this.registerAluFunction("DEC", DataType.D8, (flags, arg) -> {
            int result = arg - 1 & 0xFF;
            flags.setZ(result == 0);
            flags.setN(true);
            flags.setH((arg & 0xF) == 0);
            return result;
        });
        this.registerAluFunction("DEC", DataType.D16, (flags, arg) -> arg - 1 & 0xFFFF);
        this.registerAluFunction("ADD", DataType.D16, DataType.D16, (flags, arg1, arg2) -> {
            flags.setN(false);
            flags.setH((arg1 & 0xFFF) + (arg2 & 0xFFF) > 4095);
            flags.setC(arg1 + arg2 > 65535);
            return arg1 + arg2 & 0xFFFF;
        });
        this.registerAluFunction("ADD", DataType.D16, DataType.R8, (flags, arg1, arg2) -> arg1 + arg2 & 0xFFFF);
        this.registerAluFunction("ADD_SP", DataType.D16, DataType.R8, (flags, arg1, arg2) -> {
            flags.setZ(false);
            flags.setN(false);
            int result = arg1 + arg2;
            flags.setC(((arg1 & 0xFF) + (arg2 & 0xFF) & 0x100) != 0);
            flags.setH(((arg1 & 0xF) + (arg2 & 0xF) & 0x10) != 0);
            return result & 0xFFFF;
        });
        this.registerAluFunction("DAA", DataType.D8, (flags, arg) -> {
            int result = arg;
            if (flags.isN()) {
                if (flags.isH()) {
                    result = result - 6 & 0xFF;
                }
                if (flags.isC()) {
                    result = result - 96 & 0xFF;
                }
            } else {
                if (flags.isH() || (result & 0xF) > 9) {
                    result += 6;
                }
                if (flags.isC() || result > 159) {
                    result += 96;
                }
            }
            flags.setH(false);
            if (result > 255) {
                flags.setC(true);
            }
            flags.setZ((result &= 0xFF) == 0);
            return result;
        });
        this.registerAluFunction("CPL", DataType.D8, (flags, arg) -> {
            flags.setN(true);
            flags.setH(true);
            return ~arg & 0xFF;
        });
        this.registerAluFunction("SCF", DataType.D8, (flags, arg) -> {
            flags.setN(false);
            flags.setH(false);
            flags.setC(true);
            return arg;
        });
        this.registerAluFunction("CCF", DataType.D8, (flags, arg) -> {
            flags.setN(false);
            flags.setH(false);
            flags.setC(!flags.isC());
            return arg;
        });
        this.registerAluFunction("ADD", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            flags.setZ((byte1 + byte2 & 0xFF) == 0);
            flags.setN(false);
            flags.setH((byte1 & 0xF) + (byte2 & 0xF) > 15);
            flags.setC(byte1 + byte2 > 255);
            return byte1 + byte2 & 0xFF;
        });
        this.registerAluFunction("ADC", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            int carry = flags.isC() ? 1 : 0;
            flags.setZ((byte1 + byte2 + carry & 0xFF) == 0);
            flags.setN(false);
            flags.setH((byte1 & 0xF) + (byte2 & 0xF) + carry > 15);
            flags.setC(byte1 + byte2 + carry > 255);
            return byte1 + byte2 + carry & 0xFF;
        });
        this.registerAluFunction("SUB", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            flags.setZ((byte1 - byte2 & 0xFF) == 0);
            flags.setN(true);
            flags.setH((0xF & byte2) > (0xF & byte1));
            flags.setC(byte2 > byte1);
            return byte1 - byte2 & 0xFF;
        });
        this.registerAluFunction("SBC", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            int carry = flags.isC() ? 1 : 0;
            int res = byte1 - byte2 - carry;
            flags.setZ((res & 0xFF) == 0);
            flags.setN(true);
            flags.setH(((byte1 ^ byte2 ^ res & 0xFF) & 0x10) != 0);
            flags.setC(res < 0);
            return res & 0xFF;
        });
        this.registerAluFunction("AND", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            int result = byte1 & byte2;
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(true);
            flags.setC(false);
            return result;
        });
        this.registerAluFunction("OR", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            int result = byte1 | byte2;
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            flags.setC(false);
            return result;
        });
        this.registerAluFunction("XOR", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            int result = (byte1 ^ byte2) & 0xFF;
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            flags.setC(false);
            return result;
        });
        this.registerAluFunction("CP", DataType.D8, DataType.D8, (flags, byte1, byte2) -> {
            flags.setZ((byte1 - byte2 & 0xFF) == 0);
            flags.setN(true);
            flags.setH((0xF & byte2) > (0xF & byte1));
            flags.setC(byte2 > byte1);
            return byte1;
        });
        this.registerAluFunction("RLC", DataType.D8, (flags, arg) -> {
            int result = arg << 1 & 0xFF;
            if ((arg & 0x80) != 0) {
                result |= 1;
                flags.setC(true);
            } else {
                flags.setC(false);
            }
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("RRC", DataType.D8, (flags, arg) -> {
            int result = arg >> 1;
            if ((arg & 1) == 1) {
                result |= 0x80;
                flags.setC(true);
            } else {
                flags.setC(false);
            }
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("RL", DataType.D8, (flags, arg) -> {
            int result = arg << 1 & 0xFF;
            int n = flags.isC() ? 1 : 0;
            flags.setC((arg & 0x80) != 0);
            flags.setZ((result |= n) == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("RR", DataType.D8, (flags, arg) -> {
            int result = arg >> 1;
            int n = flags.isC() ? 128 : 0;
            flags.setC((arg & 1) != 0);
            flags.setZ((result |= n) == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("SLA", DataType.D8, (flags, arg) -> {
            int result = arg << 1 & 0xFF;
            flags.setC((arg & 0x80) != 0);
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("SRA", DataType.D8, (flags, arg) -> {
            int result = arg >> 1 | arg & 0x80;
            flags.setC((arg & 1) != 0);
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("SWAP", DataType.D8, (flags, arg) -> {
            int lower = arg & 0xF;
            int upper = arg & 0xF0;
            int result = lower << 4 | upper >> 4;
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            flags.setC(false);
            return result;
        });
        this.registerAluFunction("SRL", DataType.D8, (flags, arg) -> {
            int result = arg >> 1;
            flags.setC((arg & 1) != 0);
            flags.setZ(result == 0);
            flags.setN(false);
            flags.setH(false);
            return result;
        });
        this.registerAluFunction("BIT", DataType.D8, DataType.D8, (flags, arg1, arg2) -> {
            int bit = arg2;
            flags.setN(false);
            flags.setH(true);
            if (bit < 8) {
                flags.setZ(!BitUtils.getBit(arg1, arg2));
            }
            return arg1;
        });
        this.registerAluFunction("RES", DataType.D8, DataType.D8, (flags, arg1, arg2) -> BitUtils.clearBit(arg1, arg2));
        this.registerAluFunction("SET", DataType.D8, DataType.D8, (flags, arg1, arg2) -> BitUtils.setBit(arg1, arg2));
    }

    public IntRegistryFunction findAluFunction(String name, DataType argumentType) {
        return this.functions.get(new FunctionKey(name, argumentType));
    }

    public BiIntRegistryFunction findAluFunction(String name, DataType arg1Type, DataType arg2Type) {
        return this.biFunctions.get(new FunctionKey(name, arg1Type, arg2Type));
    }

    private void registerAluFunction(String name, DataType dataType, IntRegistryFunction function) {
        this.functions.put(new FunctionKey(name, dataType), function);
    }

    private void registerAluFunction(String name, DataType dataType1, DataType dataType2, BiIntRegistryFunction function) {
        this.biFunctions.put(new FunctionKey(name, dataType1, dataType2), function);
    }

    private static class FunctionKey {
        private final String name;
        private final DataType type1;
        private final DataType type2;

        public FunctionKey(String name, DataType type1, DataType type2) {
            this.name = name;
            this.type1 = type1;
            this.type2 = type2;
        }

        public FunctionKey(String name, DataType type) {
            this.name = name;
            this.type1 = type;
            this.type2 = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.type1.equals((Object)that.type1)) {
                return false;
            }
            return this.type2 != null ? this.type2.equals((Object)that.type2) : that.type2 == null;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type1.hashCode();
            result = 31 * result + (this.type2 != null ? this.type2.hashCode() : 0);
            return result;
        }
    }

    public static interface BiIntRegistryFunction {
        public int apply(Flags var1, int var2, int var3);
    }

    public static interface IntRegistryFunction {
        public int apply(Flags var1, int var2);
    }
}

