/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import com.google.common.base.Preconditions;

public final class BitUtils {
    private BitUtils() {
    }

    public static int getMSB(int word) {
        BitUtils.checkWordArgument("word", word);
        return word >> 8;
    }

    public static int getLSB(int word) {
        BitUtils.checkWordArgument("word", word);
        return word & 0xFF;
    }

    public static int toWord(int[] bytes) {
        return BitUtils.toWord(bytes[1], bytes[0]);
    }

    public static int toWord(int msb, int lsb) {
        BitUtils.checkByteArgument("msb", msb);
        BitUtils.checkByteArgument("lsb", lsb);
        return msb << 8 | lsb;
    }

    public static boolean getBit(int byteValue, int position) {
        return (byteValue & 1 << position) != 0;
    }

    public static int setBit(int byteValue, int position, boolean value) {
        return value ? BitUtils.setBit(byteValue, position) : BitUtils.clearBit(byteValue, position);
    }

    public static int setBit(int byteValue, int position) {
        BitUtils.checkByteArgument("byteValue", byteValue);
        return (byteValue | 1 << position) & 0xFF;
    }

    public static int clearBit(int byteValue, int position) {
        BitUtils.checkByteArgument("byteValue", byteValue);
        return ~(1 << position) & byteValue & 0xFF;
    }

    public static int toSigned(int byteValue) {
        if ((byteValue & 0x80) == 0) {
            return byteValue;
        }
        return byteValue - 256;
    }

    public static void checkByteArgument(String argumentName, int argument) {
        Preconditions.checkArgument((argument >= 0 && argument <= 255 ? 1 : 0) != 0, (String)"Argument {} should be a byte", (Object)argumentName);
    }

    public static void checkWordArgument(String argumentName, int argument) {
        Preconditions.checkArgument((argument >= 0 && argument <= 65535 ? 1 : 0) != 0, (String)"Argument {} should be a word", (Object)argumentName);
    }
}

