/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.cpu.Opcodes;
import eu.rekawek.coffeegb.cpu.Registers;
import eu.rekawek.coffeegb.cpu.SpeedMode;
import eu.rekawek.coffeegb.cpu.op.Op;
import eu.rekawek.coffeegb.cpu.opcode.Opcode;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.Gpu;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.SpriteBug;
import java.util.List;

public class Cpu {
    private final Registers registers;
    private final AddressSpace addressSpace;
    private final InterruptManager interruptManager;
    private final Gpu gpu;
    private final Display display;
    private final SpeedMode speedMode;
    private int opcode1;
    private int opcode2;
    private int[] operand = new int[2];
    private Opcode currentOpcode;
    private List<Op> ops;
    private int operandIndex;
    private int opIndex;
    private State state = State.OPCODE;
    private int opContext;
    private int interruptFlag;
    private int interruptEnabled;
    private InterruptManager.InterruptType requestedIrq;
    private int clockCycle = 0;
    private boolean haltBugMode;

    public Cpu(AddressSpace addressSpace, InterruptManager interruptManager, Gpu gpu, Display display, SpeedMode speedMode) {
        this.registers = new Registers();
        this.addressSpace = addressSpace;
        this.interruptManager = interruptManager;
        this.gpu = gpu;
        this.display = display;
        this.speedMode = speedMode;
    }

    public void tick() {
        if (++this.clockCycle < 4 / this.speedMode.getSpeedMode()) {
            return;
        }
        this.clockCycle = 0;
        if ((this.state == State.OPCODE || this.state == State.HALTED || this.state == State.STOPPED) && this.interruptManager.isIme() && this.interruptManager.isInterruptRequested()) {
            if (this.state == State.STOPPED) {
                this.display.enableLcd();
            }
            this.state = State.IRQ_READ_IF;
        }
        if (this.state == State.IRQ_READ_IF || this.state == State.IRQ_READ_IE || this.state == State.IRQ_PUSH_1 || this.state == State.IRQ_PUSH_2 || this.state == State.IRQ_JUMP) {
            this.handleInterrupt();
            return;
        }
        if (this.state == State.HALTED && this.interruptManager.isInterruptRequested()) {
            this.state = State.OPCODE;
        }
        if (this.state == State.HALTED || this.state == State.STOPPED) {
            return;
        }
        boolean accessedMemory = false;
        while (true) {
            int pc = this.registers.getPC();
            switch (this.state) {
                case OPCODE: {
                    this.clearState();
                    this.opcode1 = this.addressSpace.getByte(pc);
                    accessedMemory = true;
                    if (this.opcode1 == 203) {
                        this.state = State.EXT_OPCODE;
                    } else if (this.opcode1 == 16) {
                        this.currentOpcode = Opcodes.COMMANDS.get(this.opcode1);
                        this.state = State.EXT_OPCODE;
                    } else {
                        this.state = State.OPERAND;
                        this.currentOpcode = Opcodes.COMMANDS.get(this.opcode1);
                        if (this.currentOpcode == null) {
                            throw new IllegalStateException(String.format("No command for 0x%02x", this.opcode1));
                        }
                    }
                    if (!this.haltBugMode) {
                        this.registers.incrementPC();
                        break;
                    }
                    this.haltBugMode = false;
                    break;
                }
                case EXT_OPCODE: {
                    if (accessedMemory) {
                        return;
                    }
                    accessedMemory = true;
                    this.opcode2 = this.addressSpace.getByte(pc);
                    if (this.currentOpcode == null) {
                        this.currentOpcode = Opcodes.EXT_COMMANDS.get(this.opcode2);
                    }
                    if (this.currentOpcode == null) {
                        throw new IllegalStateException(String.format("No command for %0xcb 0x%02x", this.opcode2));
                    }
                    this.state = State.OPERAND;
                    this.registers.incrementPC();
                    break;
                }
                case OPERAND: {
                    while (this.operandIndex < this.currentOpcode.getOperandLength()) {
                        if (accessedMemory) {
                            return;
                        }
                        accessedMemory = true;
                        this.operand[this.operandIndex++] = this.addressSpace.getByte(pc);
                        this.registers.incrementPC();
                    }
                    this.ops = this.currentOpcode.getOps();
                    this.state = State.RUNNING;
                    break;
                }
                case RUNNING: {
                    if (this.opcode1 == 16) {
                        if (this.speedMode.onStop()) {
                            this.state = State.OPCODE;
                        } else {
                            this.state = State.STOPPED;
                            this.display.disableLcd();
                        }
                        return;
                    }
                    if (this.opcode1 == 118) {
                        if (this.interruptManager.isHaltBug()) {
                            this.state = State.OPCODE;
                            this.haltBugMode = true;
                            return;
                        }
                        this.state = State.HALTED;
                        return;
                    }
                    if (this.opIndex < this.ops.size()) {
                        boolean opAccessesMemory;
                        Op op = this.ops.get(this.opIndex);
                        boolean bl = opAccessesMemory = op.readsMemory() || op.writesMemory();
                        if (accessedMemory && opAccessesMemory) {
                            return;
                        }
                        ++this.opIndex;
                        SpriteBug.CorruptionType corruptionType = op.causesOemBug(this.registers, this.opContext);
                        if (corruptionType != null) {
                            this.handleSpriteBug(corruptionType);
                        }
                        this.opContext = op.execute(this.registers, this.addressSpace, this.operand, this.opContext);
                        op.switchInterrupts(this.interruptManager);
                        if (!op.proceed(this.registers)) {
                            this.opIndex = this.ops.size();
                            break;
                        }
                        if (op.forceFinishCycle()) {
                            return;
                        }
                        if (opAccessesMemory) {
                            accessedMemory = true;
                        }
                    }
                    if (this.opIndex < this.ops.size()) break;
                    this.state = State.OPCODE;
                    this.operandIndex = 0;
                    this.interruptManager.onInstructionFinished();
                    return;
                }
                case HALTED: 
                case STOPPED: {
                    return;
                }
            }
        }
    }

    private void handleInterrupt() {
        switch (this.state) {
            case IRQ_READ_IF: {
                this.interruptFlag = this.addressSpace.getByte(65295);
                this.state = State.IRQ_READ_IE;
                break;
            }
            case IRQ_READ_IE: {
                this.interruptEnabled = this.addressSpace.getByte(65535);
                this.requestedIrq = null;
                for (InterruptManager.InterruptType irq : InterruptManager.InterruptType.values()) {
                    if ((this.interruptFlag & this.interruptEnabled & 1 << irq.ordinal()) == 0) continue;
                    this.requestedIrq = irq;
                    break;
                }
                if (this.requestedIrq == null) {
                    this.state = State.OPCODE;
                    break;
                }
                this.state = State.IRQ_PUSH_1;
                this.interruptManager.clearInterrupt(this.requestedIrq);
                this.interruptManager.disableInterrupts(false);
                break;
            }
            case IRQ_PUSH_1: {
                this.registers.decrementSP();
                this.addressSpace.setByte(this.registers.getSP(), (this.registers.getPC() & 0xFF00) >> 8);
                this.state = State.IRQ_PUSH_2;
                break;
            }
            case IRQ_PUSH_2: {
                this.registers.decrementSP();
                this.addressSpace.setByte(this.registers.getSP(), this.registers.getPC() & 0xFF);
                this.state = State.IRQ_JUMP;
                break;
            }
            case IRQ_JUMP: {
                this.registers.setPC(this.requestedIrq.getHandler());
                this.requestedIrq = null;
                this.state = State.OPCODE;
            }
        }
    }

    private void handleSpriteBug(SpriteBug.CorruptionType type) {
        if (!this.gpu.getLcdc().isLcdEnabled()) {
            return;
        }
        int stat = this.addressSpace.getByte(GpuRegister.STAT.getAddress());
        if ((stat & 3) == Gpu.Mode.OamSearch.ordinal() && this.gpu.getTicksInLine() < 79) {
            SpriteBug.corruptOam(this.addressSpace, type, this.gpu.getTicksInLine());
        }
    }

    public Registers getRegisters() {
        return this.registers;
    }

    void clearState() {
        this.opcode1 = 0;
        this.opcode2 = 0;
        this.currentOpcode = null;
        this.ops = null;
        this.operand[0] = 0;
        this.operand[1] = 0;
        this.operandIndex = 0;
        this.opIndex = 0;
        this.opContext = 0;
        this.interruptFlag = 0;
        this.interruptEnabled = 0;
        this.requestedIrq = null;
    }

    public State getState() {
        return this.state;
    }

    Opcode getCurrentOpcode() {
        return this.currentOpcode;
    }

    public static enum State {
        OPCODE,
        EXT_OPCODE,
        OPERAND,
        RUNNING,
        IRQ_READ_IF,
        IRQ_READ_IE,
        IRQ_PUSH_1,
        IRQ_PUSH_2,
        IRQ_JUMP,
        STOPPED,
        HALTED;

    }
}

