/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu;

import eu.rekawek.coffeegb.cpu.BitUtils;

public class Flags {
    private static int Z_POS = 7;
    private static int N_POS = 6;
    private static int H_POS = 5;
    private static int C_POS = 4;
    private int flags;

    public int getFlagsByte() {
        return this.flags;
    }

    public boolean isZ() {
        return BitUtils.getBit(this.flags, Z_POS);
    }

    public boolean isN() {
        return BitUtils.getBit(this.flags, N_POS);
    }

    public boolean isH() {
        return BitUtils.getBit(this.flags, H_POS);
    }

    public boolean isC() {
        return BitUtils.getBit(this.flags, C_POS);
    }

    public void setZ(boolean z) {
        this.flags = BitUtils.setBit(this.flags, Z_POS, z);
    }

    public void setN(boolean n) {
        this.flags = BitUtils.setBit(this.flags, N_POS, n);
    }

    public void setH(boolean h) {
        this.flags = BitUtils.setBit(this.flags, H_POS, h);
    }

    public void setC(boolean c) {
        this.flags = BitUtils.setBit(this.flags, C_POS, c);
    }

    public void setFlagsByte(int flags) {
        BitUtils.checkByteArgument("flags", flags);
        this.flags = flags & 0xF0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.isZ() ? (char)'Z' : '-');
        result.append(this.isN() ? (char)'N' : '-');
        result.append(this.isH() ? (char)'H' : '-');
        result.append(this.isC() ? (char)'C' : '-');
        result.append("----");
        return result.toString();
    }
}

