/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.cpu.opcode;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.AluFunctions;
import eu.rekawek.coffeegb.cpu.BitUtils;
import eu.rekawek.coffeegb.cpu.Flags;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.cpu.Registers;
import eu.rekawek.coffeegb.cpu.op.Argument;
import eu.rekawek.coffeegb.cpu.op.DataType;
import eu.rekawek.coffeegb.cpu.op.Op;
import eu.rekawek.coffeegb.cpu.opcode.Opcode;
import eu.rekawek.coffeegb.gpu.SpriteBug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpcodeBuilder {
    private static final AluFunctions ALU = new AluFunctions();
    private static final Set<AluFunctions.IntRegistryFunction> OEM_BUG;
    private final int opcode;
    private final String label;
    private final List<Op> ops = new ArrayList<Op>();
    private DataType lastDataType;

    public OpcodeBuilder(int opcode, String label) {
        this.opcode = opcode;
        this.label = label;
    }

    public OpcodeBuilder copyByte(String target, String source) {
        this.load(source);
        this.store(target);
        return this;
    }

    public OpcodeBuilder load(String source) {
        final Argument arg = Argument.parse(source);
        this.lastDataType = arg.getDataType();
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return arg.isMemory();
            }

            @Override
            public int operandLength() {
                return arg.getOperandLength();
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                return arg.read(registers, addressSpace, args);
            }

            @Override
            public String toString() {
                if (arg.getDataType() == DataType.D16) {
                    return String.format("%s \u2192 [__]", arg.getLabel());
                }
                return String.format("%s \u2192 [_]", arg.getLabel());
            }
        });
        return this;
    }

    public OpcodeBuilder loadWord(final int value) {
        this.lastDataType = DataType.D16;
        this.ops.add(new Op(){

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                return value;
            }

            @Override
            public String toString() {
                return String.format("0x%02X \u2192 [__]", value);
            }
        });
        return this;
    }

    public OpcodeBuilder store(String target) {
        final Argument arg = Argument.parse(target);
        if (this.lastDataType == DataType.D16 && arg == Argument._a16) {
            this.ops.add(new Op(){

                @Override
                public boolean writesMemory() {
                    return arg.isMemory();
                }

                @Override
                public int operandLength() {
                    return arg.getOperandLength();
                }

                @Override
                public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                    addressSpace.setByte(BitUtils.toWord(args), context & 0xFF);
                    return context;
                }

                @Override
                public String toString() {
                    return String.format("[ _] \u2192 %s", arg.getLabel());
                }
            });
            this.ops.add(new Op(){

                @Override
                public boolean writesMemory() {
                    return arg.isMemory();
                }

                @Override
                public int operandLength() {
                    return arg.getOperandLength();
                }

                @Override
                public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                    addressSpace.setByte(BitUtils.toWord(args) + 1 & 0xFFFF, (context & 0xFF00) >> 8);
                    return context;
                }

                @Override
                public String toString() {
                    return String.format("[_ ] \u2192 %s", arg.getLabel());
                }
            });
        } else if (this.lastDataType == arg.getDataType()) {
            this.ops.add(new Op(){

                @Override
                public boolean writesMemory() {
                    return arg.isMemory();
                }

                @Override
                public int operandLength() {
                    return arg.getOperandLength();
                }

                @Override
                public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                    arg.write(registers, addressSpace, args, context);
                    return context;
                }

                @Override
                public String toString() {
                    if (arg.getDataType() == DataType.D16) {
                        return String.format("[__] \u2192 %s", arg.getLabel());
                    }
                    return String.format("[_] \u2192 %s", arg.getLabel());
                }
            });
        } else {
            throw new IllegalStateException("Can't write " + (Object)((Object)this.lastDataType) + " to " + target);
        }
        return this;
    }

    public OpcodeBuilder proceedIf(final String condition) {
        this.ops.add(new Op(){

            @Override
            public boolean proceed(Registers registers) {
                switch (condition) {
                    case "NZ": {
                        return !registers.getFlags().isZ();
                    }
                    case "Z": {
                        return registers.getFlags().isZ();
                    }
                    case "NC": {
                        return !registers.getFlags().isC();
                    }
                    case "C": {
                        return registers.getFlags().isC();
                    }
                }
                return false;
            }

            @Override
            public String toString() {
                return String.format("? %s:", condition);
            }
        });
        return this;
    }

    public OpcodeBuilder push() {
        final AluFunctions.IntRegistryFunction dec = ALU.findAluFunction("DEC", DataType.D16);
        this.ops.add(new Op(){

            @Override
            public boolean writesMemory() {
                return true;
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                registers.setSP(dec.apply(registers.getFlags(), registers.getSP()));
                addressSpace.setByte(registers.getSP(), (context & 0xFF00) >> 8);
                return context;
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.inOamArea(registers.getSP()) ? SpriteBug.CorruptionType.PUSH_1 : null;
            }

            @Override
            public String toString() {
                return String.format("[_ ] \u2192 (SP--)", new Object[0]);
            }
        });
        this.ops.add(new Op(){

            @Override
            public boolean writesMemory() {
                return true;
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                registers.setSP(dec.apply(registers.getFlags(), registers.getSP()));
                addressSpace.setByte(registers.getSP(), context & 0xFF);
                return context;
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.inOamArea(registers.getSP()) ? SpriteBug.CorruptionType.PUSH_2 : null;
            }

            @Override
            public String toString() {
                return String.format("[ _] \u2192 (SP--)", new Object[0]);
            }
        });
        return this;
    }

    public OpcodeBuilder pop() {
        final AluFunctions.IntRegistryFunction inc = ALU.findAluFunction("INC", DataType.D16);
        this.lastDataType = DataType.D16;
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return true;
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                int lsb = addressSpace.getByte(registers.getSP());
                registers.setSP(inc.apply(registers.getFlags(), registers.getSP()));
                return lsb;
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.inOamArea(registers.getSP()) ? SpriteBug.CorruptionType.POP_1 : null;
            }

            @Override
            public String toString() {
                return String.format("(SP++) \u2192 [ _]", new Object[0]);
            }
        });
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return true;
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                int msb = addressSpace.getByte(registers.getSP());
                registers.setSP(inc.apply(registers.getFlags(), registers.getSP()));
                return context | msb << 8;
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.inOamArea(registers.getSP()) ? SpriteBug.CorruptionType.POP_2 : null;
            }

            @Override
            public String toString() {
                return String.format("(SP++) \u2192 [_ ]", new Object[0]);
            }
        });
        return this;
    }

    public OpcodeBuilder alu(final String operation, String argument2) {
        final Argument arg2 = Argument.parse(argument2);
        final AluFunctions.BiIntRegistryFunction func = ALU.findAluFunction(operation, this.lastDataType, arg2.getDataType());
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return arg2.isMemory();
            }

            @Override
            public int operandLength() {
                return arg2.getOperandLength();
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int v1) {
                int v2 = arg2.read(registers, addressSpace, args);
                return func.apply(registers.getFlags(), v1, v2);
            }

            @Override
            public String toString() {
                if (OpcodeBuilder.this.lastDataType == DataType.D16) {
                    return String.format("%s([__],%s) \u2192 [__]", new Object[]{operation, arg2});
                }
                return String.format("%s([_],%s) \u2192 [_]", new Object[]{operation, arg2});
            }
        });
        if (this.lastDataType == DataType.D16) {
            this.extraCycle();
        }
        return this;
    }

    public OpcodeBuilder alu(final String operation, final int d8Value) {
        final AluFunctions.BiIntRegistryFunction func = ALU.findAluFunction(operation, this.lastDataType, DataType.D8);
        this.ops.add(new Op(){

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int v1) {
                return func.apply(registers.getFlags(), v1, d8Value);
            }

            @Override
            public String toString() {
                return String.format("%s(%d,[_]) \u2192 [_]", operation, d8Value);
            }
        });
        if (this.lastDataType == DataType.D16) {
            this.extraCycle();
        }
        return this;
    }

    public OpcodeBuilder alu(final String operation) {
        final AluFunctions.IntRegistryFunction func = ALU.findAluFunction(operation, this.lastDataType);
        this.ops.add(new Op(){

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int value) {
                return func.apply(registers.getFlags(), value);
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.causesOemBug(func, context) ? SpriteBug.CorruptionType.INC_DEC : null;
            }

            @Override
            public String toString() {
                if (OpcodeBuilder.this.lastDataType == DataType.D16) {
                    return String.format("%s([__]) \u2192 [__]", operation);
                }
                return String.format("%s([_]) \u2192 [_]", operation);
            }
        });
        if (this.lastDataType == DataType.D16) {
            this.extraCycle();
        }
        return this;
    }

    public OpcodeBuilder aluHL(String operation) {
        this.load("HL");
        final AluFunctions.IntRegistryFunction func = ALU.findAluFunction(operation, DataType.D16);
        this.ops.add(new Op(){

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int value) {
                return func.apply(registers.getFlags(), value);
            }

            @Override
            public SpriteBug.CorruptionType causesOemBug(Registers registers, int context) {
                return OpcodeBuilder.causesOemBug(func, context) ? SpriteBug.CorruptionType.LD_HL : null;
            }

            @Override
            public String toString() {
                return String.format("%s(HL) \u2192 [__]", new Object[0]);
            }
        });
        this.store("HL");
        return this;
    }

    public OpcodeBuilder bitHL(final int bit) {
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return true;
            }

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                int value = addressSpace.getByte(registers.getHL());
                Flags flags = registers.getFlags();
                flags.setN(false);
                flags.setH(true);
                if (bit < 8) {
                    flags.setZ(!BitUtils.getBit(value, bit));
                }
                return context;
            }

            @Override
            public String toString() {
                return String.format("BIT(%d,HL)", bit);
            }
        });
        return this;
    }

    public OpcodeBuilder clearZ() {
        this.ops.add(new Op(){

            @Override
            public int execute(Registers registers, AddressSpace addressSpace, int[] args, int context) {
                registers.getFlags().setZ(false);
                return context;
            }

            @Override
            public String toString() {
                return String.format("0 \u2192 Z", new Object[0]);
            }
        });
        return this;
    }

    public OpcodeBuilder switchInterrupts(final boolean enable, final boolean withDelay) {
        this.ops.add(new Op(){

            @Override
            public void switchInterrupts(InterruptManager interruptManager) {
                if (enable) {
                    interruptManager.enableInterrupts(withDelay);
                } else {
                    interruptManager.disableInterrupts(withDelay);
                }
            }

            @Override
            public String toString() {
                return (enable ? "enable" : "disable") + " interrupts";
            }
        });
        return this;
    }

    public OpcodeBuilder op(Op op) {
        this.ops.add(op);
        return this;
    }

    public OpcodeBuilder extraCycle() {
        this.ops.add(new Op(){

            @Override
            public boolean readsMemory() {
                return true;
            }

            @Override
            public String toString() {
                return "wait cycle";
            }
        });
        return this;
    }

    public OpcodeBuilder forceFinish() {
        this.ops.add(new Op(){

            @Override
            public boolean forceFinishCycle() {
                return true;
            }

            @Override
            public String toString() {
                return "finish cycle";
            }
        });
        return this;
    }

    public Opcode build() {
        return new Opcode(this);
    }

    int getOpcode() {
        return this.opcode;
    }

    String getLabel() {
        return this.label;
    }

    List<Op> getOps() {
        return this.ops;
    }

    public String toString() {
        return this.label;
    }

    private static boolean causesOemBug(AluFunctions.IntRegistryFunction function, int context) {
        return OEM_BUG.contains(function) && OpcodeBuilder.inOamArea(context);
    }

    private static boolean inOamArea(int address) {
        return address >= 65024 && address <= 65279;
    }

    static {
        HashSet<AluFunctions.IntRegistryFunction> oemBugFunctions = new HashSet<AluFunctions.IntRegistryFunction>();
        oemBugFunctions.add(ALU.findAluFunction("INC", DataType.D16));
        oemBugFunctions.add(ALU.findAluFunction("DEC", DataType.D16));
        OEM_BUG = Collections.unmodifiableSet(oemBugFunctions);
    }
}

