/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug.command;

import com.google.common.collect.Maps;
import eu.rekawek.coffeegb.debug.Command;
import eu.rekawek.coffeegb.debug.CommandArgument;
import eu.rekawek.coffeegb.debug.CommandPattern;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ShowHelp
implements Command {
    private static final CommandPattern PATTERN = CommandPattern.Builder.create("help", "?").withDescription("displays supported commands").build();
    private final List<Command> commands;

    public ShowHelp(List<Command> commands) {
        this.commands = commands;
    }

    @Override
    public CommandPattern getPattern() {
        return PATTERN;
    }

    @Override
    public void run(CommandPattern.ParsedCommandLine commandLine) {
        CommandPattern pattern;
        int max = 0;
        HashMap commandMap = Maps.newHashMap();
        for (Command command : this.commands) {
            pattern = command.getPattern();
            String alias = pattern.getCommandNames().get(0);
            String commandWithArgs = this.getCommandWithArgs(alias, pattern.getArguments());
            if (commandWithArgs.length() > max) {
                max = commandWithArgs.length();
            }
            commandMap.put(command, commandWithArgs);
        }
        for (Command command : this.commands) {
            pattern = command.getPattern();
            String longName = (String)commandMap.get(command);
            System.out.print(String.format("%-" + max + "s", longName));
            if (pattern.getCommandNames().size() > 1) {
                System.out.print(String.format("   %-5s", pattern.getCommandNames().get(1)));
            } else {
                System.out.print("        ");
            }
            command.getPattern().getDescription().map(d -> "   " + d).ifPresent(System.out::print);
            System.out.println();
        }
    }

    private String getCommandWithArgs(String alias, List<CommandArgument> args) {
        StringBuilder builder = new StringBuilder(alias);
        if (!args.isEmpty()) {
            builder.append(' ').append(String.join((CharSequence)" ", args.stream().map(CommandArgument::toString).collect(Collectors.toList())));
        }
        return builder.toString();
    }
}

