/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.debug.command.cpu;

import eu.rekawek.coffeegb.cpu.Opcodes;
import eu.rekawek.coffeegb.cpu.opcode.Opcode;
import eu.rekawek.coffeegb.debug.Command;
import eu.rekawek.coffeegb.debug.CommandPattern;
import java.util.List;

public class ShowOpcodes
implements Command {
    private static final CommandPattern PATTERN = CommandPattern.Builder.create("cpu show opcodes").withDescription("displays all opcodes").build();

    @Override
    public CommandPattern getPattern() {
        return PATTERN;
    }

    @Override
    public void run(CommandPattern.ParsedCommandLine commandLine) {
        ShowOpcodes.printTable(Opcodes.COMMANDS);
        System.out.println("\n0xCB");
        ShowOpcodes.printTable(Opcodes.EXT_COMMANDS);
    }

    private static void printTable(List<Opcode> opcodes) {
        int i;
        System.out.print("   ");
        for (i = 0; i < 16; ++i) {
            System.out.print(String.format("%02X          ", i));
        }
        System.out.println();
        for (i = 0; i < 256; i += 16) {
            System.out.print(String.format("%02X ", i));
            for (int j = 0; j < 16; ++j) {
                Opcode opcode = opcodes.get(i + j);
                String label = opcode == null ? "-" : opcode.getLabel();
                System.out.print(String.format("%-12s", label));
            }
            System.out.println();
        }
    }
}

