/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.IntQueue;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.PixelFifo;
import eu.rekawek.coffeegb.gpu.TileAttributes;
import eu.rekawek.coffeegb.memory.MemoryRegisters;

public class DmgPixelFifo
implements PixelFifo {
    private final IntQueue pixels = new IntQueue(16);
    private final IntQueue palettes = new IntQueue(16);
    private final IntQueue pixelType = new IntQueue(16);
    private final Display display;
    private final Lcdc lcdc;
    private final MemoryRegisters registers;

    public DmgPixelFifo(Display display, Lcdc lcdc, MemoryRegisters registers) {
        this.lcdc = lcdc;
        this.display = display;
        this.registers = registers;
    }

    @Override
    public int getLength() {
        return this.pixels.size();
    }

    @Override
    public void putPixelToScreen() {
        this.display.putDmgPixel(this.dequeuePixel());
    }

    @Override
    public void dropPixel() {
        this.dequeuePixel();
    }

    int dequeuePixel() {
        this.pixelType.dequeue();
        return DmgPixelFifo.getColor(this.palettes.dequeue(), this.pixels.dequeue());
    }

    @Override
    public void enqueue8Pixels(int[] pixelLine, TileAttributes tileAttributes) {
        for (int p : pixelLine) {
            this.pixels.enqueue(p);
            this.palettes.enqueue(this.registers.get(GpuRegister.BGP));
            this.pixelType.enqueue(0);
        }
    }

    @Override
    public void setOverlay(int[] pixelLine, int offset, TileAttributes flags, int oamIndex) {
        boolean priority = flags.isPriority();
        int overlayPalette = this.registers.get(flags.getDmgPalette());
        for (int j = offset; j < pixelLine.length; ++j) {
            int p = pixelLine[j];
            int i = j - offset;
            if (this.pixelType.get(i) == 1 || (!priority || this.pixels.get(i) != 0) && (priority || p == 0)) continue;
            this.pixels.set(i, p);
            this.palettes.set(i, overlayPalette);
            this.pixelType.set(i, 1);
        }
    }

    IntQueue getPixels() {
        return this.pixels;
    }

    private static int getColor(int palette, int colorIndex) {
        return 3 & palette >> colorIndex * 2;
    }

    @Override
    public void clear() {
        this.pixels.clear();
        this.palettes.clear();
        this.pixelType.clear();
    }
}

