/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.BitUtils;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.PixelFifo;
import eu.rekawek.coffeegb.gpu.TileAttributes;
import eu.rekawek.coffeegb.gpu.phase.OamSearch;
import eu.rekawek.coffeegb.memory.MemoryRegisters;
import java.util.EnumSet;

public class Fetcher {
    private static final int[] EMPTY_PIXEL_LINE = new int[8];
    private final PixelFifo fifo;
    private final AddressSpace videoRam0;
    private final AddressSpace videoRam1;
    private final AddressSpace oemRam;
    private final MemoryRegisters r;
    private final Lcdc lcdc;
    private final boolean gbc;
    private final int[] pixelLine = new int[8];
    private State state;
    private boolean fetchingDisabled;
    private int mapAddress;
    private int xOffset;
    private int tileDataAddress;
    private boolean tileIdSigned;
    private int tileLine;
    private int tileId;
    private TileAttributes tileAttributes;
    private int tileData1;
    private int tileData2;
    private int spriteTileLine;
    private OamSearch.SpritePosition sprite;
    private TileAttributes spriteAttributes;
    private int spriteOffset;
    private int spriteOamIndex;
    private int divider = 2;

    public Fetcher(PixelFifo fifo, AddressSpace videoRam0, AddressSpace videoRam1, AddressSpace oemRam, Lcdc lcdc, MemoryRegisters registers, boolean gbc) {
        this.gbc = gbc;
        this.fifo = fifo;
        this.videoRam0 = videoRam0;
        this.videoRam1 = videoRam1;
        this.oemRam = oemRam;
        this.r = registers;
        this.lcdc = lcdc;
    }

    public void init() {
        this.state = State.READ_TILE_ID;
        this.tileId = 0;
        this.tileData1 = 0;
        this.tileData2 = 0;
        this.divider = 2;
        this.fetchingDisabled = false;
    }

    public void startFetching(int mapAddress, int tileDataAddress, int xOffset, boolean tileIdSigned, int tileLine) {
        this.mapAddress = mapAddress;
        this.tileDataAddress = tileDataAddress;
        this.xOffset = xOffset;
        this.tileIdSigned = tileIdSigned;
        this.tileLine = tileLine;
        this.fifo.clear();
        this.state = State.READ_TILE_ID;
        this.tileId = 0;
        this.tileData1 = 0;
        this.tileData2 = 0;
        this.divider = 2;
    }

    public void fetchingDisabled() {
        this.fetchingDisabled = true;
    }

    public void addSprite(OamSearch.SpritePosition sprite, int offset, int oamIndex) {
        this.sprite = sprite;
        this.state = State.READ_SPRITE_TILE_ID;
        this.spriteTileLine = this.r.get(GpuRegister.LY) + 16 - sprite.getY();
        this.spriteOffset = offset;
        this.spriteOamIndex = oamIndex;
    }

    public void tick() {
        if (this.fetchingDisabled && this.state == State.READ_TILE_ID) {
            if (this.fifo.getLength() <= 8) {
                this.fifo.enqueue8Pixels(EMPTY_PIXEL_LINE, this.tileAttributes);
            }
            return;
        }
        if (--this.divider != 0) {
            return;
        }
        this.divider = 2;
        switch (this.state) {
            case READ_TILE_ID: {
                this.tileId = this.videoRam0.getByte(this.mapAddress + this.xOffset);
                this.tileAttributes = this.gbc ? TileAttributes.valueOf(this.videoRam1.getByte(this.mapAddress + this.xOffset)) : TileAttributes.EMPTY;
                this.state = State.READ_DATA_1;
                break;
            }
            case READ_DATA_1: {
                this.tileData1 = this.getTileData(this.tileId, this.tileLine, 0, this.tileDataAddress, this.tileIdSigned, this.tileAttributes, 8);
                this.state = State.READ_DATA_2;
                break;
            }
            case READ_DATA_2: {
                this.tileData2 = this.getTileData(this.tileId, this.tileLine, 1, this.tileDataAddress, this.tileIdSigned, this.tileAttributes, 8);
                this.state = State.PUSH;
            }
            case PUSH: {
                if (this.fifo.getLength() > 8) break;
                this.fifo.enqueue8Pixels(this.zip(this.tileData1, this.tileData2, this.tileAttributes.isXflip()), this.tileAttributes);
                this.xOffset = (this.xOffset + 1) % 32;
                this.state = State.READ_TILE_ID;
                break;
            }
            case READ_SPRITE_TILE_ID: {
                this.tileId = this.oemRam.getByte(this.sprite.getAddress() + 2);
                this.state = State.READ_SPRITE_FLAGS;
                break;
            }
            case READ_SPRITE_FLAGS: {
                this.spriteAttributes = TileAttributes.valueOf(this.oemRam.getByte(this.sprite.getAddress() + 3));
                this.state = State.READ_SPRITE_DATA_1;
                break;
            }
            case READ_SPRITE_DATA_1: {
                if (this.lcdc.getSpriteHeight() == 16) {
                    this.tileId &= 0xFE;
                }
                this.tileData1 = this.getTileData(this.tileId, this.spriteTileLine, 0, 32768, false, this.spriteAttributes, this.lcdc.getSpriteHeight());
                this.state = State.READ_SPRITE_DATA_2;
                break;
            }
            case READ_SPRITE_DATA_2: {
                this.tileData2 = this.getTileData(this.tileId, this.spriteTileLine, 1, 32768, false, this.spriteAttributes, this.lcdc.getSpriteHeight());
                this.state = State.PUSH_SPRITE;
                break;
            }
            case PUSH_SPRITE: {
                this.fifo.setOverlay(this.zip(this.tileData1, this.tileData2, this.spriteAttributes.isXflip()), this.spriteOffset, this.spriteAttributes, this.spriteOamIndex);
                this.state = State.READ_TILE_ID;
            }
        }
    }

    private int getTileData(int tileId, int line, int byteNumber, int tileDataAddress, boolean signed, TileAttributes attr, int tileHeight) {
        int effectiveLine = attr.isYflip() ? tileHeight - 1 - line : line;
        int tileAddress = signed ? tileDataAddress + BitUtils.toSigned(tileId) * 16 : tileDataAddress + tileId * 16;
        AddressSpace videoRam = attr.getBank() == 0 || !this.gbc ? this.videoRam0 : this.videoRam1;
        return videoRam.getByte(tileAddress + effectiveLine * 2 + byteNumber);
    }

    public boolean spriteInProgress() {
        return EnumSet.of(State.READ_SPRITE_TILE_ID, State.READ_SPRITE_FLAGS, State.READ_SPRITE_DATA_1, State.READ_SPRITE_DATA_2, State.PUSH_SPRITE).contains((Object)this.state);
    }

    public int[] zip(int data1, int data2, boolean reverse) {
        return Fetcher.zip(data1, data2, reverse, this.pixelLine);
    }

    public static int[] zip(int data1, int data2, boolean reverse, int[] pixelLine) {
        for (int i = 7; i >= 0; --i) {
            int mask = 1 << i;
            int p = 2 * ((data2 & mask) == 0 ? 0 : 1) + ((data1 & mask) == 0 ? 0 : 1);
            if (reverse) {
                pixelLine[i] = p;
                continue;
            }
            pixelLine[7 - i] = p;
        }
        return pixelLine;
    }

    private static enum State {
        READ_TILE_ID,
        READ_DATA_1,
        READ_DATA_2,
        PUSH,
        READ_SPRITE_TILE_ID,
        READ_SPRITE_FLAGS,
        READ_SPRITE_DATA_1,
        READ_SPRITE_DATA_2,
        PUSH_SPRITE;

    }
}

