/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.gpu.ColorPalette;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.phase.GpuPhase;
import eu.rekawek.coffeegb.gpu.phase.HBlankPhase;
import eu.rekawek.coffeegb.gpu.phase.OamSearch;
import eu.rekawek.coffeegb.gpu.phase.PixelTransfer;
import eu.rekawek.coffeegb.gpu.phase.VBlankPhase;
import eu.rekawek.coffeegb.memory.Dma;
import eu.rekawek.coffeegb.memory.MemoryRegisters;
import eu.rekawek.coffeegb.memory.Ram;

public class Gpu
implements AddressSpace {
    private final AddressSpace videoRam0;
    private final AddressSpace videoRam1;
    private final AddressSpace oamRam;
    private final Display display;
    private final InterruptManager interruptManager;
    private final Dma dma;
    private final Lcdc lcdc;
    private final boolean gbc;
    private final ColorPalette bgPalette;
    private final ColorPalette oamPalette;
    private final HBlankPhase hBlankPhase;
    private final OamSearch oamSearchPhase;
    private final PixelTransfer pixelTransferPhase;
    private final VBlankPhase vBlankPhase;
    private boolean lcdEnabled = true;
    private int lcdEnabledDelay;
    private MemoryRegisters r = new MemoryRegisters(GpuRegister.values());
    private int ticksInLine;
    private Mode mode;
    private GpuPhase phase;

    public Gpu(Display display, InterruptManager interruptManager, Dma dma, Ram oamRam, boolean gbc) {
        this.lcdc = new Lcdc();
        this.interruptManager = interruptManager;
        this.gbc = gbc;
        this.videoRam0 = new Ram(32768, 8192);
        this.videoRam1 = gbc ? new Ram(32768, 8192) : null;
        this.oamRam = oamRam;
        this.dma = dma;
        this.bgPalette = new ColorPalette(65384);
        this.oamPalette = new ColorPalette(65386);
        this.oamPalette.fillWithFF();
        this.oamSearchPhase = new OamSearch(oamRam, this.lcdc, this.r);
        this.pixelTransferPhase = new PixelTransfer(this.videoRam0, this.videoRam1, oamRam, display, this.lcdc, this.r, gbc, this.bgPalette, this.oamPalette);
        this.hBlankPhase = new HBlankPhase();
        this.vBlankPhase = new VBlankPhase();
        this.mode = Mode.OamSearch;
        this.phase = this.oamSearchPhase.start();
        this.display = display;
    }

    private AddressSpace getAddressSpace(int address) {
        if (this.videoRam0.accepts(address)) {
            return this.getVideoRam();
        }
        if (this.oamRam.accepts(address) && !this.dma.isOamBlocked()) {
            return this.oamRam;
        }
        if (this.lcdc.accepts(address)) {
            return this.lcdc;
        }
        if (this.r.accepts(address)) {
            return this.r;
        }
        if (this.gbc && this.bgPalette.accepts(address)) {
            return this.bgPalette;
        }
        if (this.gbc && this.oamPalette.accepts(address)) {
            return this.oamPalette;
        }
        return null;
    }

    private AddressSpace getVideoRam() {
        if (this.gbc && (this.r.get(GpuRegister.VBK) & 1) == 1) {
            return this.videoRam1;
        }
        return this.videoRam0;
    }

    public AddressSpace getVideoRam0() {
        return this.videoRam0;
    }

    public AddressSpace getVideoRam1() {
        return this.videoRam1;
    }

    @Override
    public boolean accepts(int address) {
        return this.getAddressSpace(address) != null;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == GpuRegister.STAT.getAddress()) {
            this.setStat(value);
        } else {
            AddressSpace space = this.getAddressSpace(address);
            if (space == this.lcdc) {
                this.setLcdc(value);
            } else if (space != null) {
                space.setByte(address, value);
            }
        }
    }

    @Override
    public int getByte(int address) {
        if (address == GpuRegister.STAT.getAddress()) {
            return this.getStat();
        }
        AddressSpace space = this.getAddressSpace(address);
        if (space == null) {
            return 255;
        }
        if (address == GpuRegister.VBK.getAddress()) {
            return this.gbc ? 254 : 255;
        }
        return space.getByte(address);
    }

    public Mode tick() {
        if (!this.lcdEnabled && this.lcdEnabledDelay != -1 && --this.lcdEnabledDelay == 0) {
            this.display.enableLcd();
            this.lcdEnabled = true;
        }
        if (!this.lcdEnabled) {
            return null;
        }
        Mode oldMode = this.mode;
        ++this.ticksInLine;
        if (this.phase.tick()) {
            if (this.ticksInLine == 4 && this.mode == Mode.VBlank && this.r.get(GpuRegister.LY) == 153) {
                this.r.put(GpuRegister.LY, 0);
                this.requestLycEqualsLyInterrupt();
            }
        } else {
            switch (oldMode) {
                case OamSearch: {
                    this.mode = Mode.PixelTransfer;
                    this.phase = this.pixelTransferPhase.start(this.oamSearchPhase.getSprites());
                    break;
                }
                case PixelTransfer: {
                    this.mode = Mode.HBlank;
                    this.phase = this.hBlankPhase.start(this.ticksInLine);
                    this.requestLcdcInterrupt(3);
                    break;
                }
                case HBlank: {
                    this.ticksInLine = 0;
                    if (this.r.preIncrement(GpuRegister.LY) == 144) {
                        this.mode = Mode.VBlank;
                        this.phase = this.vBlankPhase.start();
                        this.interruptManager.requestInterrupt(InterruptManager.InterruptType.VBlank);
                        this.requestLcdcInterrupt(4);
                    } else {
                        this.mode = Mode.OamSearch;
                        this.phase = this.oamSearchPhase.start();
                    }
                    this.requestLcdcInterrupt(5);
                    this.requestLycEqualsLyInterrupt();
                    break;
                }
                case VBlank: {
                    this.ticksInLine = 0;
                    if (this.r.preIncrement(GpuRegister.LY) == 1) {
                        this.mode = Mode.OamSearch;
                        this.r.put(GpuRegister.LY, 0);
                        this.phase = this.oamSearchPhase.start();
                        this.requestLcdcInterrupt(5);
                    } else {
                        this.phase = this.vBlankPhase.start();
                    }
                    this.requestLycEqualsLyInterrupt();
                }
            }
        }
        if (oldMode == this.mode) {
            return null;
        }
        return this.mode;
    }

    public int getTicksInLine() {
        return this.ticksInLine;
    }

    private void requestLcdcInterrupt(int statBit) {
        if ((this.r.get(GpuRegister.STAT) & 1 << statBit) != 0) {
            this.interruptManager.requestInterrupt(InterruptManager.InterruptType.LCDC);
        }
    }

    private void requestLycEqualsLyInterrupt() {
        if (this.r.get(GpuRegister.LYC) == this.r.get(GpuRegister.LY)) {
            this.requestLcdcInterrupt(6);
        }
    }

    private int getStat() {
        return this.r.get(GpuRegister.STAT) | this.mode.ordinal() | (this.r.get(GpuRegister.LYC) == this.r.get(GpuRegister.LY) ? 4 : 0) | 0x80;
    }

    private void setStat(int value) {
        this.r.put(GpuRegister.STAT, value & 0xF8);
    }

    private void setLcdc(int value) {
        this.lcdc.set(value);
        if ((value & 0x80) == 0) {
            this.disableLcd();
        } else {
            this.enableLcd();
        }
    }

    private void disableLcd() {
        this.r.put(GpuRegister.LY, 0);
        this.ticksInLine = 0;
        this.phase = this.hBlankPhase.start(250);
        this.mode = Mode.HBlank;
        this.lcdEnabled = false;
        this.lcdEnabledDelay = -1;
        this.display.disableLcd();
    }

    private void enableLcd() {
        this.lcdEnabledDelay = 244;
    }

    public boolean isLcdEnabled() {
        return this.lcdEnabled;
    }

    public Lcdc getLcdc() {
        return this.lcdc;
    }

    public MemoryRegisters getRegisters() {
        return this.r;
    }

    public boolean isGbc() {
        return this.gbc;
    }

    public ColorPalette getBgPalette() {
        return this.bgPalette;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        HBlank,
        VBlank,
        OamSearch,
        PixelTransfer;

    }
}

