/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gpu.phase;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.gpu.ColorPalette;
import eu.rekawek.coffeegb.gpu.ColorPixelFifo;
import eu.rekawek.coffeegb.gpu.Display;
import eu.rekawek.coffeegb.gpu.DmgPixelFifo;
import eu.rekawek.coffeegb.gpu.Fetcher;
import eu.rekawek.coffeegb.gpu.GpuRegister;
import eu.rekawek.coffeegb.gpu.Lcdc;
import eu.rekawek.coffeegb.gpu.PixelFifo;
import eu.rekawek.coffeegb.gpu.phase.GpuPhase;
import eu.rekawek.coffeegb.gpu.phase.OamSearch;
import eu.rekawek.coffeegb.memory.MemoryRegisters;

public class PixelTransfer
implements GpuPhase {
    private final PixelFifo fifo;
    private final Fetcher fetcher;
    private final Display display;
    private final MemoryRegisters r;
    private final Lcdc lcdc;
    private final boolean gbc;
    private OamSearch.SpritePosition[] sprites;
    private int droppedPixels;
    private int x;
    private boolean window;

    public PixelTransfer(AddressSpace videoRam0, AddressSpace videoRam1, AddressSpace oemRam, Display display, Lcdc lcdc, MemoryRegisters r, boolean gbc, ColorPalette bgPalette, ColorPalette oamPalette) {
        this.r = r;
        this.lcdc = lcdc;
        this.gbc = gbc;
        this.fifo = gbc ? new ColorPixelFifo(lcdc, display, bgPalette, oamPalette) : new DmgPixelFifo(display, lcdc, r);
        this.fetcher = new Fetcher(this.fifo, videoRam0, videoRam1, oemRam, lcdc, r, gbc);
        this.display = display;
    }

    public PixelTransfer start(OamSearch.SpritePosition[] sprites) {
        this.sprites = sprites;
        this.droppedPixels = 0;
        this.x = 0;
        this.window = false;
        this.fetcher.init();
        if (this.gbc || this.lcdc.isBgAndWindowDisplay()) {
            this.startFetchingBackground();
        } else {
            this.fetcher.fetchingDisabled();
        }
        return this;
    }

    @Override
    public boolean tick() {
        this.fetcher.tick();
        if (this.lcdc.isBgAndWindowDisplay() || this.gbc) {
            if (this.fifo.getLength() <= 8) {
                return true;
            }
            if (this.droppedPixels < this.r.get(GpuRegister.SCX) % 8) {
                this.fifo.dropPixel();
                ++this.droppedPixels;
                return true;
            }
            if (!this.window && this.lcdc.isWindowDisplay() && this.r.get(GpuRegister.LY) >= this.r.get(GpuRegister.WY) && this.x == this.r.get(GpuRegister.WX) - 7) {
                this.window = true;
                this.startFetchingWindow();
                return true;
            }
        }
        if (this.lcdc.isObjDisplay()) {
            if (this.fetcher.spriteInProgress()) {
                return true;
            }
            boolean spriteAdded = false;
            for (int i = 0; i < this.sprites.length; ++i) {
                OamSearch.SpritePosition s = this.sprites[i];
                if (s == null) continue;
                if (this.x == 0 && s.getX() < 8) {
                    if (!spriteAdded) {
                        this.fetcher.addSprite(s, 8 - s.getX(), i);
                        spriteAdded = true;
                    }
                    this.sprites[i] = null;
                } else if (s.getX() - 8 == this.x) {
                    if (!spriteAdded) {
                        this.fetcher.addSprite(s, 0, i);
                        spriteAdded = true;
                    }
                    this.sprites[i] = null;
                }
                if (!spriteAdded) continue;
                return true;
            }
        }
        this.fifo.putPixelToScreen();
        return ++this.x != 160;
    }

    private void startFetchingBackground() {
        int bgX = this.r.get(GpuRegister.SCX) / 8;
        int bgY = (this.r.get(GpuRegister.SCY) + this.r.get(GpuRegister.LY)) % 256;
        this.fetcher.startFetching(this.lcdc.getBgTileMapDisplay() + bgY / 8 * 32, this.lcdc.getBgWindowTileData(), bgX, this.lcdc.isBgWindowTileDataSigned(), bgY % 8);
    }

    private void startFetchingWindow() {
        int winX = (this.x - this.r.get(GpuRegister.WX) + 7) / 8;
        int winY = this.r.get(GpuRegister.LY) - this.r.get(GpuRegister.WY);
        this.fetcher.startFetching(this.lcdc.getWindowTileMapDisplay() + winY / 8 * 32, this.lcdc.getBgWindowTileData(), winX, this.lcdc.isBgWindowTileDataSigned(), winY % 8);
    }
}

