/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.gui;

import com.google.common.base.Preconditions;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.sound.SoundOutput;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;

public class AudioSystemSoundOutput
implements SoundOutput {
    private static final Logger LOG = LoggerHelper.getLogger(AudioSystemSoundOutput.class);
    private static final int SAMPLE_RATE = 44100;
    private static final int BUFFER_SIZE = 1024;
    private static final AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
    private SourceDataLine line;
    private byte[] buffer;
    private int i;
    private int tick;
    private int divider;

    @Override
    public void start() {
        if (this.line != null) {
            LOG.debug("Sound already started");
            return;
        }
        LOG.debug("Start sound");
        try {
            this.line = AudioSystem.getSourceDataLine(FORMAT);
            this.line.open(FORMAT, 1024);
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException(e);
        }
        this.line.start();
        this.buffer = new byte[this.line.getBufferSize()];
        this.divider = (int)(4194304.0f / FORMAT.getSampleRate());
    }

    @Override
    public void stop() {
        if (this.line == null) {
            LOG.debug("Can't stop - sound wasn't started");
        }
        LOG.debug("Stop sound");
        this.line.drain();
        this.line.stop();
        this.line = null;
    }

    @Override
    public void play(int left, int right) {
        if (this.tick++ != 0) {
            this.tick %= this.divider;
            return;
        }
        Preconditions.checkArgument((left >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((left < 256 ? 1 : 0) != 0);
        Preconditions.checkArgument((right >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((right < 256 ? 1 : 0) != 0);
        int mono8 = (left + right >> 1) + -128;
        int mono16 = mono8 << 8;
        this.buffer[this.i++] = (byte)(mono16 & 0xFF);
        this.buffer[this.i++] = (byte)(mono16 >> 8 & 0xFF);
        if (this.i > 512) {
            this.line.write(this.buffer, 0, this.i);
            this.i = 0;
        }
    }
}

