/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.gpu.Gpu;
import eu.rekawek.coffeegb.memory.Ram;

public class Hdma
implements AddressSpace {
    private static final int HDMA1 = 65361;
    private static final int HDMA2 = 65362;
    private static final int HDMA3 = 65363;
    private static final int HDMA4 = 65364;
    private static final int HDMA5 = 65365;
    private final AddressSpace addressSpace;
    private final Ram hdma1234 = new Ram(65361, 4);
    private Gpu.Mode gpuMode;
    private boolean transferInProgress;
    private boolean hblankTransfer;
    private boolean lcdEnabled;
    private int length;
    private int src;
    private int dst;
    private int tick;

    public Hdma(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
    }

    @Override
    public boolean accepts(int address) {
        return address >= 65361 && address <= 65365;
    }

    public void tick() {
        if (!this.isTransferInProgress()) {
            return;
        }
        if (++this.tick < 32) {
            return;
        }
        for (int j = 0; j < 16; ++j) {
            this.addressSpace.setByte(this.dst + j, this.addressSpace.getByte(this.src + j));
        }
        this.src += 16;
        this.dst += 16;
        if (this.length-- == 0) {
            this.transferInProgress = false;
            this.length = 127;
        } else if (this.hblankTransfer) {
            this.gpuMode = null;
        }
    }

    @Override
    public void setByte(int address, int value) {
        if (this.hdma1234.accepts(address)) {
            this.hdma1234.setByte(address, value);
        } else if (address == 65365) {
            if (this.transferInProgress && (address & 0x80) == 0) {
                this.stopTransfer();
            } else {
                this.startTransfer(value);
            }
        }
    }

    @Override
    public int getByte(int address) {
        if (this.hdma1234.accepts(address)) {
            return 255;
        }
        if (address == 65365) {
            return (this.transferInProgress ? 0 : 128) | this.length;
        }
        throw new IllegalArgumentException();
    }

    public void onGpuUpdate(Gpu.Mode newGpuMode) {
        this.gpuMode = newGpuMode;
    }

    public void onLcdSwitch(boolean lcdEnabled) {
        this.lcdEnabled = lcdEnabled;
    }

    public boolean isTransferInProgress() {
        if (!this.transferInProgress) {
            return false;
        }
        if (this.hblankTransfer && (this.gpuMode == Gpu.Mode.HBlank || !this.lcdEnabled)) {
            return true;
        }
        return !this.hblankTransfer;
    }

    private void startTransfer(int reg) {
        this.hblankTransfer = (reg & 0x80) != 0;
        this.length = reg & 0x7F;
        this.src = this.hdma1234.getByte(65361) << 8 | this.hdma1234.getByte(65362) & 0xF0;
        this.dst = (this.hdma1234.getByte(65363) & 0x1F) << 8 | this.hdma1234.getByte(65364) & 0xF0;
        this.src &= 0xFFF0;
        this.dst = this.dst & 0x1FFF | 0x8000;
        this.transferInProgress = true;
    }

    private void stopTransfer() {
        this.transferInProgress = false;
    }
}

