/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MemoryRegisters
implements AddressSpace {
    private Map<Integer, Register> registers;
    private Map<Integer, Integer> values = new HashMap<Integer, Integer>();

    public MemoryRegisters(Register ... registers) {
        HashMap<Integer, Register> map = new HashMap<Integer, Register>();
        for (Register r : registers) {
            if (map.containsKey(r.getAddress())) {
                throw new IllegalArgumentException("Two registers with the same address: " + r.getAddress());
            }
            map.put(r.getAddress(), r);
            this.values.put(r.getAddress(), 0);
        }
        this.registers = Collections.unmodifiableMap(map);
    }

    private MemoryRegisters(MemoryRegisters original) {
        this.registers = original.registers;
        this.values = Collections.unmodifiableMap(new HashMap<Integer, Integer>(original.values));
    }

    public int get(Register reg) {
        if (this.registers.containsKey(reg.getAddress())) {
            return this.values.get(reg.getAddress());
        }
        throw new IllegalArgumentException("Not valid register: " + reg);
    }

    public void put(Register reg, int value) {
        if (!this.registers.containsKey(reg.getAddress())) {
            throw new IllegalArgumentException("Not valid register: " + reg);
        }
        this.values.put(reg.getAddress(), value);
    }

    public MemoryRegisters freeze() {
        return new MemoryRegisters(this);
    }

    public int preIncrement(Register reg) {
        if (this.registers.containsKey(reg.getAddress())) {
            int value = this.values.get(reg.getAddress()) + 1;
            this.values.put(reg.getAddress(), value);
            return value;
        }
        throw new IllegalArgumentException("Not valid register: " + reg);
    }

    @Override
    public boolean accepts(int address) {
        return this.registers.containsKey(address);
    }

    @Override
    public void setByte(int address, int value) {
        if (this.registers.get(address).getType().allowsWrite) {
            this.values.put(address, value);
        }
    }

    @Override
    public int getByte(int address) {
        if (this.registers.get(address).getType().allowsRead) {
            return this.values.get(address);
        }
        return 255;
    }

    public static enum RegisterType {
        R(true, false),
        W(false, true),
        RW(true, true);

        private final boolean allowsRead;
        private final boolean allowsWrite;

        private RegisterType(boolean allowsRead, boolean allowsWrite) {
            this.allowsRead = allowsRead;
            this.allowsWrite = allowsWrite;
        }
    }

    public static interface Register {
        public int getAddress();

        public RegisterType getType();
    }
}

