/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.cpu.BitUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class Mmu
implements AddressSpace {
    private static final Logger LOG = LoggerHelper.getLogger(Mmu.class);
    private static final AddressSpace VOID = new AddressSpace(){

        @Override
        public boolean accepts(int address) {
            return true;
        }

        @Override
        public void setByte(int address, int value) {
            if (address < 0 || address > 65535) {
                throw new IllegalArgumentException("Invalid address: " + Integer.toHexString(address));
            }
            LOG.debug("Writing value {} to void address {}", (Object)Integer.toHexString(value), (Object)Integer.toHexString(address));
        }

        @Override
        public int getByte(int address) {
            if (address < 0 || address > 65535) {
                throw new IllegalArgumentException("Invalid address: " + Integer.toHexString(address));
            }
            LOG.debug("Reading value from void address {}", (Object)Integer.toHexString(address));
            return 255;
        }
    };
    private final List<AddressSpace> spaces = new ArrayList<AddressSpace>();

    public void addAddressSpace(AddressSpace space) {
        this.spaces.add(space);
    }

    @Override
    public boolean accepts(int address) {
        return true;
    }

    @Override
    public void setByte(int address, int value) {
        BitUtils.checkByteArgument("value", value);
        BitUtils.checkWordArgument("address", address);
        this.getSpace(address).setByte(address, value);
    }

    @Override
    public int getByte(int address) {
        BitUtils.checkWordArgument("address", address);
        return this.getSpace(address).getByte(address);
    }

    private AddressSpace getSpace(int address) {
        for (AddressSpace s : this.spaces) {
            if (!s.accepts(address)) continue;
            return s;
        }
        return VOID;
    }
}

