/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory;

import eu.rekawek.coffeegb.AddressSpace;

public class ShadowAddressSpace
implements AddressSpace {
    private final AddressSpace addressSpace;
    private final int echoStart;
    private final int targetStart;
    private final int length;

    public ShadowAddressSpace(AddressSpace addressSpace, int echoStart, int targetStart, int length) {
        this.addressSpace = addressSpace;
        this.echoStart = echoStart;
        this.targetStart = targetStart;
        this.length = length;
    }

    @Override
    public boolean accepts(int address) {
        return address >= this.echoStart && address < this.echoStart + this.length;
    }

    @Override
    public void setByte(int address, int value) {
        this.addressSpace.setByte(this.translate(address), value);
    }

    @Override
    public int getByte(int address) {
        return this.addressSpace.getByte(this.translate(address));
    }

    private int translate(int address) {
        return this.getRelative(address) + this.targetStart;
    }

    private int getRelative(int address) {
        int i = address - this.echoStart;
        if (i < 0 || i >= this.length) {
            throw new IllegalArgumentException();
        }
        return i;
    }
}

