/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.GameboyOptions;
import eu.rekawek.coffeegb.LoggerHelper;
import eu.rekawek.coffeegb.memory.BootRom;
import eu.rekawek.coffeegb.memory.cart.CartridgeType;
import eu.rekawek.coffeegb.memory.cart.battery.Battery;
import eu.rekawek.coffeegb.memory.cart.battery.FileBattery;
import eu.rekawek.coffeegb.memory.cart.type.Mbc1;
import eu.rekawek.coffeegb.memory.cart.type.Mbc2;
import eu.rekawek.coffeegb.memory.cart.type.Mbc3;
import eu.rekawek.coffeegb.memory.cart.type.Mbc5;
import eu.rekawek.coffeegb.memory.cart.type.Rom;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;

public class Cartridge
implements AddressSpace {
    private static final Logger LOG = LoggerHelper.getLogger(Cartridge.class);
    private final AddressSpace addressSpace;
    private final GameboyTypeFlag gameboyType;
    private final boolean gbc;
    private final String title;
    private int dmgBoostrap;

    public Cartridge(GameboyOptions options) throws IOException {
        File file = options.getRomFile();
        int[] rom = Cartridge.loadFile(file);
        CartridgeType type = CartridgeType.getById(rom[327]);
        this.title = this.getTitle(rom);
        LOG.debug("Cartridge {}, type: {}", (Object)this.title, (Object)type);
        this.gameboyType = GameboyTypeFlag.getFlag(rom[323]);
        int romBanks = Cartridge.getRomBanks(rom[328]);
        int ramBanks = Cartridge.getRamBanks(rom[329]);
        if (ramBanks == 0 && type.isRam()) {
            LOG.warn("RAM bank is defined to 0. Overriding to 1.");
            ramBanks = 1;
        }
        LOG.debug("ROM banks: {}, RAM banks: {}", (Object)romBanks, (Object)ramBanks);
        Battery battery = Battery.NULL_BATTERY;
        if (type.isBattery() && options.isSupportBatterySaves()) {
            battery = new FileBattery(file.getParentFile(), Files.getNameWithoutExtension((String)file.getName()));
        }
        this.addressSpace = type.isMbc1() ? new Mbc1(rom, type, battery, romBanks, ramBanks) : (type.isMbc2() ? new Mbc2(rom, type, battery, romBanks) : (type.isMbc3() ? new Mbc3(rom, type, battery, romBanks, ramBanks) : (type.isMbc5() ? new Mbc5(rom, type, battery, romBanks, ramBanks) : new Rom(rom, type, romBanks, ramBanks))));
        int n = this.dmgBoostrap = options.isUsingBootstrap() ? 0 : 1;
        this.gbc = options.isForceCgb() ? true : (this.gameboyType == GameboyTypeFlag.NON_CGB ? false : (this.gameboyType == GameboyTypeFlag.CGB ? true : !options.isForceDmg()));
    }

    private String getTitle(int[] rom) {
        char c;
        StringBuilder t = new StringBuilder();
        for (int i = 308; i < 323 && (c = (char)rom[i]) != '\u0000'; ++i) {
            t.append(c);
        }
        return t.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isGbc() {
        return this.gbc;
    }

    @Override
    public boolean accepts(int address) {
        return this.addressSpace.accepts(address) || address == 65360;
    }

    @Override
    public void setByte(int address, int value) {
        if (address == 65360) {
            this.dmgBoostrap = 1;
        } else {
            this.addressSpace.setByte(address, value);
        }
    }

    @Override
    public int getByte(int address) {
        if (this.dmgBoostrap == 0 && !this.gbc && address >= 0 && address < 256) {
            return BootRom.GAMEBOY_CLASSIC[address];
        }
        if (this.dmgBoostrap == 0 && this.gbc && address >= 0 && address < 256) {
            return BootRom.GAMEBOY_COLOR[address];
        }
        if (this.dmgBoostrap == 0 && this.gbc && address >= 512 && address < 2304) {
            return BootRom.GAMEBOY_COLOR[address - 256];
        }
        if (address == 65360) {
            return 255;
        }
        return this.addressSpace.getByte(address);
    }

    private static int[] loadFile(File file) throws IOException {
        String ext = Files.getFileExtension((String)file.getName());
        try (FileInputStream is = new FileInputStream(file);){
            if ("zip".equalsIgnoreCase(ext)) {
                try (ZipInputStream zis = new ZipInputStream(is);){
                    while (true) {
                        ZipEntry entry;
                        if ((entry = zis.getNextEntry()) != null) {
                            String name = entry.getName();
                            String entryExt = Files.getFileExtension((String)name);
                            if (Stream.of("gb", "gbc", "rom").anyMatch(e -> e.equalsIgnoreCase(entryExt))) {
                                int[] nArray = Cartridge.load(zis, (int)entry.getSize());
                                return nArray;
                            }
                            zis.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                throw new IllegalArgumentException("Can't find ROM file inside the zip.");
            }
            int[] nArray = Cartridge.load(is, (int)file.length());
            return nArray;
        }
    }

    private static int[] load(InputStream is, int length) throws IOException {
        byte[] byteArray = ByteStreams.toByteArray((InputStream)is);
        int[] intArray = new int[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            intArray[i] = byteArray[i] & 0xFF;
        }
        return intArray;
    }

    private static int getRomBanks(int id) {
        switch (id) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 256;
            }
            case 82: {
                return 72;
            }
            case 83: {
                return 80;
            }
            case 84: {
                return 96;
            }
        }
        throw new IllegalArgumentException("Unsupported ROM size: " + Integer.toHexString(id));
    }

    private static int getRamBanks(int id) {
        switch (id) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Unsupported RAM size: " + Integer.toHexString(id));
    }

    public static enum GameboyTypeFlag {
        UNIVERSAL,
        CGB,
        NON_CGB;


        private static GameboyTypeFlag getFlag(int value) {
            if (value == 128) {
                return UNIVERSAL;
            }
            if (value == 192) {
                return CGB;
            }
            return NON_CGB;
        }
    }
}

