/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.memory.cart.type;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.memory.cart.CartridgeType;
import eu.rekawek.coffeegb.memory.cart.battery.Battery;
import eu.rekawek.coffeegb.memory.cart.rtc.Clock;
import eu.rekawek.coffeegb.memory.cart.rtc.RealTimeClock;

public class Mbc3
implements AddressSpace {
    private final CartridgeType type;
    private final int ramBanks;
    private final int[] cartridge;
    private final int[] ram;
    private final RealTimeClock clock;
    private final Battery battery;
    private int selectedRamBank;
    private int selectedRomBank = 1;
    private boolean ramWriteEnabled;
    private int latchClockReg = 255;
    private boolean clockLatched;

    public Mbc3(int[] cartridge, CartridgeType type, Battery battery, int romBanks, int ramBanks) {
        this.cartridge = cartridge;
        this.ramBanks = ramBanks;
        this.ram = new int[8192 * Math.max(this.ramBanks, 1)];
        for (int i = 0; i < this.ram.length; ++i) {
            this.ram[i] = 255;
        }
        this.type = type;
        this.clock = new RealTimeClock(Clock.SYSTEM_CLOCK);
        this.battery = battery;
        long[] clockData = new long[12];
        battery.loadRamWithClock(this.ram, clockData);
        this.clock.deserialize(clockData);
    }

    @Override
    public boolean accepts(int address) {
        return address >= 0 && address < 32768 || address >= 40960 && address < 49152;
    }

    @Override
    public void setByte(int address, int value) {
        if (address >= 0 && address < 8192) {
            boolean bl = this.ramWriteEnabled = (value & 0xA) != 0;
            if (!this.ramWriteEnabled) {
                this.battery.saveRamWithClock(this.ram, this.clock.serialize());
            }
        } else if (address >= 8192 && address < 16384) {
            int bank = value & 0x7F;
            this.selectRomBank(bank);
        } else if (address >= 16384 && address < 24576) {
            this.selectedRamBank = value;
        } else if (address >= 24576 && address < 32768) {
            if (value == 1 && this.latchClockReg == 0) {
                if (this.clockLatched) {
                    this.clock.unlatch();
                    this.clockLatched = false;
                } else {
                    this.clock.latch();
                    this.clockLatched = true;
                }
            }
            this.latchClockReg = value;
        } else if (address >= 40960 && address < 49152 && this.ramWriteEnabled && this.selectedRamBank < 4) {
            int ramAddress = this.getRamAddress(address);
            if (ramAddress < this.ram.length) {
                this.ram[ramAddress] = value;
            }
        } else if (address >= 40960 && address < 49152 && this.ramWriteEnabled && this.selectedRamBank >= 4) {
            this.setTimer(value);
        }
    }

    private void selectRomBank(int bank) {
        if (bank == 0) {
            bank = 1;
        }
        this.selectedRomBank = bank;
    }

    @Override
    public int getByte(int address) {
        if (address >= 0 && address < 16384) {
            return this.getRomByte(0, address);
        }
        if (address >= 16384 && address < 32768) {
            return this.getRomByte(this.selectedRomBank, address - 16384);
        }
        if (address >= 40960 && address < 49152 && this.selectedRamBank < 4) {
            int ramAddress = this.getRamAddress(address);
            if (ramAddress < this.ram.length) {
                return this.ram[ramAddress];
            }
            return 255;
        }
        if (address >= 40960 && address < 49152 && this.selectedRamBank >= 4) {
            return this.getTimer();
        }
        throw new IllegalArgumentException(Integer.toHexString(address));
    }

    private int getRomByte(int bank, int address) {
        int cartOffset = bank * 16384 + address;
        if (cartOffset < this.cartridge.length) {
            return this.cartridge[cartOffset];
        }
        return 255;
    }

    private int getRamAddress(int address) {
        return this.selectedRamBank * 8192 + (address - 40960);
    }

    private int getTimer() {
        switch (this.selectedRamBank) {
            case 8: {
                return this.clock.getSeconds();
            }
            case 9: {
                return this.clock.getMinutes();
            }
            case 10: {
                return this.clock.getHours();
            }
            case 11: {
                return this.clock.getDayCounter() & 0xFF;
            }
            case 12: {
                int result = (this.clock.getDayCounter() & 0x100) >> 8;
                result |= this.clock.isHalt() ? 64 : 0;
                return result |= this.clock.isCounterOverflow() ? 128 : 0;
            }
        }
        return 255;
    }

    private void setTimer(int value) {
        int dayCounter = this.clock.getDayCounter();
        switch (this.selectedRamBank) {
            case 8: {
                this.clock.setSeconds(value);
                break;
            }
            case 9: {
                this.clock.setMinutes(value);
                break;
            }
            case 10: {
                this.clock.setHours(value);
                break;
            }
            case 11: {
                this.clock.setDayCounter(dayCounter & 0x100 | value & 0xFF);
                break;
            }
            case 12: {
                this.clock.setDayCounter(dayCounter & 0xFF | (value & 1) << 8);
                this.clock.setHalt((value & 0x40) != 0);
                if ((value & 0x80) != 0) break;
                this.clock.clearCounterOverflow();
            }
        }
    }
}

