/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.sound;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.sound.LengthCounter;

public abstract class AbstractSoundMode
implements AddressSpace {
    protected final int offset;
    protected final boolean gbc;
    protected boolean channelEnabled;
    protected boolean dacEnabled;
    protected int nr0;
    protected int nr1;
    protected int nr2;
    protected int nr3;
    protected int nr4;
    protected LengthCounter length;

    public AbstractSoundMode(int offset, int length, boolean gbc) {
        this.offset = offset;
        this.length = new LengthCounter(length);
        this.gbc = gbc;
    }

    public abstract int tick();

    protected abstract void trigger();

    public boolean isEnabled() {
        return this.channelEnabled && this.dacEnabled;
    }

    @Override
    public boolean accepts(int address) {
        return address >= this.offset && address < this.offset + 5;
    }

    @Override
    public void setByte(int address, int value) {
        switch (address - this.offset) {
            case 0: {
                this.setNr0(value);
                break;
            }
            case 1: {
                this.setNr1(value);
                break;
            }
            case 2: {
                this.setNr2(value);
                break;
            }
            case 3: {
                this.setNr3(value);
                break;
            }
            case 4: {
                this.setNr4(value);
            }
        }
    }

    @Override
    public int getByte(int address) {
        switch (address - this.offset) {
            case 0: {
                return this.getNr0();
            }
            case 1: {
                return this.getNr1();
            }
            case 2: {
                return this.getNr2();
            }
            case 3: {
                return this.getNr3();
            }
            case 4: {
                return this.getNr4();
            }
        }
        throw new IllegalArgumentException("Illegal address for sound mode: " + Integer.toHexString(address));
    }

    protected void setNr0(int value) {
        this.nr0 = value;
    }

    protected void setNr1(int value) {
        this.nr1 = value;
    }

    protected void setNr2(int value) {
        this.nr2 = value;
    }

    protected void setNr3(int value) {
        this.nr3 = value;
    }

    protected void setNr4(int value) {
        this.nr4 = value;
        this.length.setNr4(value);
        if ((value & 0x80) != 0) {
            this.channelEnabled = this.dacEnabled;
            this.trigger();
        }
    }

    protected int getNr0() {
        return this.nr0;
    }

    protected int getNr1() {
        return this.nr1;
    }

    protected int getNr2() {
        return this.nr2;
    }

    protected int getNr3() {
        return this.nr3;
    }

    protected int getNr4() {
        return this.nr4;
    }

    protected int getFrequency() {
        return 2048 - (this.getNr3() | (this.getNr4() & 7) << 8);
    }

    public abstract void start();

    public void stop() {
        this.channelEnabled = false;
    }

    protected boolean updateLength() {
        this.length.tick();
        if (!this.length.isEnabled()) {
            return this.channelEnabled;
        }
        if (this.channelEnabled && this.length.getValue() == 0) {
            this.channelEnabled = false;
        }
        return this.channelEnabled;
    }
}

