/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.coffeegb.timer;

import eu.rekawek.coffeegb.AddressSpace;
import eu.rekawek.coffeegb.cpu.InterruptManager;
import eu.rekawek.coffeegb.cpu.SpeedMode;

public class Timer
implements AddressSpace {
    private final SpeedMode speedMode;
    private final InterruptManager interruptManager;
    private static final int[] FREQ_TO_BIT = new int[]{9, 3, 5, 7};
    private int div;
    private int tac;
    private int tma;
    private int tima;
    private boolean previousBit;
    private boolean overflow;
    private int ticksSinceOverflow;

    public Timer(InterruptManager interruptManager, SpeedMode speedMode) {
        this.speedMode = speedMode;
        this.interruptManager = interruptManager;
    }

    public void tick() {
        this.updateDiv(this.div + 1 & 0xFFFF);
        if (this.overflow) {
            ++this.ticksSinceOverflow;
            if (this.ticksSinceOverflow == 4) {
                this.interruptManager.requestInterrupt(InterruptManager.InterruptType.Timer);
            }
            if (this.ticksSinceOverflow == 5) {
                this.tima = this.tma;
            }
            if (this.ticksSinceOverflow == 6) {
                this.tima = this.tma;
                this.overflow = false;
                this.ticksSinceOverflow = 0;
            }
        }
    }

    private void incTima() {
        ++this.tima;
        this.tima %= 256;
        if (this.tima == 0) {
            this.overflow = true;
            this.ticksSinceOverflow = 0;
        }
    }

    private void updateDiv(int newDiv) {
        this.div = newDiv;
        int bitPos = FREQ_TO_BIT[this.tac & 3];
        boolean bit = (this.div & 1 << (bitPos <<= this.speedMode.getSpeedMode() - 1)) != 0;
        if (!(bit &= (this.tac & 4) != 0) && this.previousBit) {
            this.incTima();
        }
        this.previousBit = bit;
    }

    @Override
    public boolean accepts(int address) {
        return address >= 65284 && address <= 65287;
    }

    @Override
    public void setByte(int address, int value) {
        switch (address) {
            case 65284: {
                this.updateDiv(0);
                break;
            }
            case 65285: {
                if (this.ticksSinceOverflow >= 5) break;
                this.tima = value;
                this.overflow = false;
                this.ticksSinceOverflow = 0;
                break;
            }
            case 65286: {
                this.tma = value;
                break;
            }
            case 65287: {
                this.tac = value;
            }
        }
    }

    @Override
    public int getByte(int address) {
        switch (address) {
            case 65284: {
                return this.div >> 8;
            }
            case 65285: {
                return this.tima;
            }
            case 65286: {
                return this.tma;
            }
            case 65287: {
                return this.tac | 0xF8;
            }
        }
        throw new IllegalArgumentException();
    }
}

